/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.network.packets;

import mezz.jei.common.config.IServerConfig;
import mezz.jei.common.network.IConnectionToClient;
import mezz.jei.common.network.ServerPacketContext;
import mezz.jei.common.network.packets.PacketCheatPermission;
import mezz.jei.common.network.packets.PlayToServerPacket;
import mezz.jei.common.util.ServerCommandUtil;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PacketDeletePlayerItem
extends PlayToServerPacket<PacketDeletePlayerItem> {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final class_8710.class_9154<PacketDeletePlayerItem> TYPE = new class_8710.class_9154(class_2960.method_60655((String)"jei", (String)"delete_player_item"));
    public static final class_9139<class_9129, PacketDeletePlayerItem> STREAM_CODEC = class_9139.method_56434((class_9139)class_1799.field_48349, p -> p.itemStack, PacketDeletePlayerItem::new);
    private final class_1799 itemStack;

    public PacketDeletePlayerItem(class_1799 itemStack) {
        this.itemStack = itemStack;
    }

    @Override
    public class_8710.class_9154<PacketDeletePlayerItem> method_56479() {
        return TYPE;
    }

    @Override
    public class_9139<class_9129, PacketDeletePlayerItem> streamCodec() {
        return STREAM_CODEC;
    }

    @Override
    public void process(ServerPacketContext context) {
        IServerConfig serverConfig;
        class_3222 player = context.player();
        if (ServerCommandUtil.hasPermissionForCheatMode(player, serverConfig = context.serverConfig())) {
            class_1799 playerItem = player.field_7512.method_34255();
            if (playerItem.method_7909() == this.itemStack.method_7909()) {
                player.field_7512.method_34254(class_1799.field_8037);
            } else if (!playerItem.method_7960()) {
                LOGGER.warn("Player '{} ({})' tried to delete ItemStack '{}' but is currently holding a different ItemStack '{}'.", (Object)player.method_5477(), (Object)player.method_5667(), (Object)this.itemStack.method_7954(), (Object)playerItem.method_7954());
            }
        } else {
            class_1799 playerItem = player.field_7512.method_34255();
            LOGGER.error("Player '{} ({})' tried to delete ItemStack '{}' but does not have permission.", (Object)player.method_5477(), (Object)player.method_5667(), (Object)playerItem.method_7954());
            IConnectionToClient connection = context.connection();
            connection.sendPacketToClient(new PacketCheatPermission(false, serverConfig), player);
        }
    }
}

