/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.util.rendering.ui.widget.slider.v2;

import de.keksuccino.fancymenu.util.ConsumingSupplier;
import de.keksuccino.fancymenu.util.rendering.ui.widget.slider.v2.AbstractExtendedSlider;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_3532;
import org.jetbrains.annotations.NotNull;

public class ListSlider<T>
extends AbstractExtendedSlider {
    @NotNull
    protected List<T> listValues;
    @NotNull
    protected ConsumingSupplier<T, String> listValueStringSupplier = consumes -> consumes != null ? consumes.toString() : "";

    public ListSlider(int x, int y, int width, int height, class_2561 label, @NotNull List<T> listValues, int preSelectedIndex) {
        super(x, y, width, height, label, 0.0);
        this.listValues = new ArrayList<T>(listValues);
        if (this.listValues.size() < 2) {
            throw new RuntimeException("Not enough list values! At least 2 list values needed!");
        }
        this.setSelectedIndex(preSelectedIndex);
    }

    @Override
    @NotNull
    public String getValueDisplayText() {
        return this.listValueStringSupplier.get(this.getSelectedListValue());
    }

    @NotNull
    public T getSelectedListValue() {
        return this.listValues.get(Math.min(this.listValues.size() - 1, Math.max(0, this.getSelectedIndex())));
    }

    public int getSelectedIndex() {
        if (!this.listValues.isEmpty()) {
            double minValue = 0.0;
            double maxValue = this.listValues.size() - 1;
            return (int)class_3532.method_16436((double)class_3532.method_15350((double)this.field_22753, (double)0.0, (double)1.0), (double)minValue, (double)maxValue);
        }
        return 0;
    }

    public ListSlider<T> setSelectedIndex(double index) {
        if (!this.listValues.isEmpty()) {
            double minValue = 0.0;
            double maxValue = this.listValues.size() - 1;
            this.method_25347((class_3532.method_15350((double)index, (double)minValue, (double)maxValue) - minValue) / (maxValue - minValue));
        }
        return this;
    }

    public void setListValueStringSupplier(@NotNull ConsumingSupplier<T, String> supplier) {
        this.listValueStringSupplier = supplier;
    }
}

