/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.util.rendering.ui.scroll.v2.scrollarea.entry;

import de.keksuccino.fancymenu.util.rendering.DrawableColor;
import de.keksuccino.fancymenu.util.rendering.ui.UIBase;
import de.keksuccino.fancymenu.util.rendering.ui.scroll.v2.scrollarea.ScrollArea;
import de.keksuccino.fancymenu.util.rendering.ui.scroll.v2.scrollarea.entry.ScrollAreaEntry;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5348;
import org.jetbrains.annotations.NotNull;

public class TextListScrollAreaEntry
extends ScrollAreaEntry {
    public DrawableColor listDotColor;
    protected class_2561 text;
    protected int textWidth;
    public class_327 font;
    protected Consumer<TextListScrollAreaEntry> onClickCallback;
    protected int textBaseColor;
    protected int labelRenderOffsetY;

    public TextListScrollAreaEntry(ScrollArea parent, @NotNull class_2561 text, @NotNull DrawableColor listDotColor, @NotNull Consumer<TextListScrollAreaEntry> onClick) {
        super(parent, 0.0f, 16.0f);
        this.font = class_310.method_1551().field_1772;
        this.textBaseColor = UIBase.getUIColorTheme().generic_text_base_color.getColorInt();
        this.labelRenderOffsetY = 1;
        this.listDotColor = listDotColor;
        this.onClickCallback = onClick;
        this.setText(text);
    }

    @Override
    public void renderEntry(@NotNull class_332 graphics, int mouseX, int mouseY, float partial) {
        float centerY = this.getY() + this.getHeight() / 2.0f;
        TextListScrollAreaEntry.renderListingDot(graphics, this.getX() + 5.0f, centerY - 2.0f, this.listDotColor.getColorInt());
        int n = (int)(this.getX() + 5.0f + 4.0f + 3.0f);
        Objects.requireNonNull(this.font);
        graphics.method_51439(this.font, this.text, n, (int)(centerY - 9.0f / 2.0f) + this.getLabelRenderOffsetY(), this.textBaseColor, false);
    }

    @Override
    public void onClick(ScrollAreaEntry entry, double mouseX, double mouseY, int button) {
        this.onClickCallback.accept((TextListScrollAreaEntry)entry);
    }

    public void setText(@NotNull class_2561 text) {
        this.text = text;
        this.textWidth = this.font.method_27525((class_5348)this.text);
        this.setWidth(12 + this.textWidth + 5);
    }

    public class_2561 getText() {
        return this.text;
    }

    public int getTextWidth() {
        return this.textWidth;
    }

    public int getTextBaseColor() {
        return this.textBaseColor;
    }

    public void setTextBaseColor(int textBaseColor) {
        this.textBaseColor = textBaseColor;
    }

    public int getLabelRenderOffsetY() {
        return this.labelRenderOffsetY;
    }

    public void setLabelRenderOffsetY(int labelRenderOffsetY) {
        this.labelRenderOffsetY = labelRenderOffsetY;
    }
}

