/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.util.rendering.ui.screen;

import de.keksuccino.fancymenu.util.ConsumingSupplier;
import de.keksuccino.fancymenu.util.input.CharacterFilter;
import de.keksuccino.fancymenu.util.rendering.ui.UIBase;
import de.keksuccino.fancymenu.util.rendering.ui.tooltip.Tooltip;
import de.keksuccino.fancymenu.util.rendering.ui.widget.button.ExtendedButton;
import de.keksuccino.fancymenu.util.rendering.ui.widget.editbox.ExtendedEditBox;
import java.util.function.Consumer;
import net.minecraft.class_11908;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextInputScreen
extends class_437 {
    @NotNull
    protected Consumer<String> callback;
    protected ExtendedEditBox input;
    protected ExtendedButton cancelButton;
    protected ExtendedButton doneButton;
    protected ConsumingSupplier<TextInputScreen, Boolean> textValidator = null;
    protected Tooltip textValidatorFeedbackTooltip = null;

    @NotNull
    public static TextInputScreen build(@NotNull class_2561 title, @Nullable CharacterFilter filter, @NotNull Consumer<String> callback) {
        return new TextInputScreen(title, filter, callback);
    }

    public TextInputScreen(@NotNull class_2561 title, @Nullable CharacterFilter filter, @NotNull Consumer<String> callback) {
        super(title);
        this.callback = callback;
        this.input = new ExtendedEditBox(class_310.method_1551().field_1772, 0, 0, 200, 20, (class_2561)class_2561.method_43473());
        this.input.method_1880(10000);
        this.input.setCharacterFilter(filter);
        UIBase.applyDefaultWidgetSkinTo(this.input);
    }

    protected void method_25426() {
        this.method_25429((class_364)this.input);
        this.method_25395((class_364)this.input);
        this.cancelButton = new ExtendedButton(0, 0, 100, 20, (class_2561)class_2561.method_43471((String)"fancymenu.common_components.cancel"), button -> this.callback.accept(null));
        this.method_25429((class_364)this.cancelButton);
        UIBase.applyDefaultWidgetSkinTo(this.cancelButton);
        this.doneButton = new ExtendedButton(0, 0, 100, 20, (class_2561)class_2561.method_43471((String)"fancymenu.common_components.done"), button -> {
            if (this.isTextValid()) {
                this.callback.accept(this.input.method_1882());
            }
        });
        this.method_25429((class_364)this.doneButton);
        UIBase.applyDefaultWidgetSkinTo(this.doneButton);
    }

    public void method_25394(@NotNull class_332 graphics, int mouseX, int mouseY, float partial) {
        graphics.method_25294(0, 0, this.field_22789, this.field_22790, UIBase.getUIColorTheme().screen_background_color.getColorInt());
        class_5250 t = this.field_22785.method_27661().method_27696(class_2583.field_24360.method_10982(Boolean.valueOf(true)));
        int titleWidth = class_310.method_1551().field_1772.method_27525((class_5348)t);
        graphics.method_51439(this.field_22793, (class_2561)t, this.field_22789 / 2 - titleWidth / 2, this.field_22790 / 2 - 30, UIBase.getUIColorTheme().generic_text_base_color.getColorInt(), false);
        this.input.method_46421(this.field_22789 / 2 - this.input.method_25368() / 2);
        this.input.method_46419(this.field_22790 / 2 - this.input.method_25364() / 2);
        this.input.method_25394(graphics, mouseX, mouseY, partial);
        this.cancelButton.method_46421(this.field_22789 / 2 - 5 - this.cancelButton.method_25368());
        this.cancelButton.method_46419(this.field_22790 - 40);
        this.cancelButton.method_25394(graphics, mouseX, mouseY, partial);
        this.doneButton.field_22763 = this.isTextValid();
        if (this.textValidatorFeedbackTooltip != null) {
            this.textValidatorFeedbackTooltip.setDefaultStyle();
        }
        this.doneButton.setTooltip(this.textValidatorFeedbackTooltip);
        this.doneButton.method_46421(this.field_22789 / 2 + 5);
        this.doneButton.method_46419(this.field_22790 - 40);
        this.doneButton.method_25394(graphics, mouseX, mouseY, partial);
    }

    public void method_25420(@NotNull class_332 graphics, int mouseX, int mouseY, float partial) {
    }

    public boolean method_25404(class_11908 event) {
        if (event.comp_4795() == 257 && this.isTextValid()) {
            this.callback.accept(this.input.method_1882());
            return true;
        }
        return super.method_25404(event);
    }

    public void method_25419() {
        this.callback.accept(null);
    }

    public TextInputScreen setText(@Nullable String text) {
        if (text == null) {
            text = "";
        }
        this.input.method_1852(text);
        return this;
    }

    public String getText() {
        return this.input.method_1882();
    }

    protected boolean isTextValid() {
        if (this.textValidator != null) {
            return this.textValidator.get(this);
        }
        return true;
    }

    public TextInputScreen setTextValidator(@Nullable ConsumingSupplier<TextInputScreen, Boolean> textValidator) {
        this.textValidator = textValidator;
        return this;
    }

    public TextInputScreen setTextValidatorUserFeedback(@Nullable Tooltip feedback) {
        this.textValidatorFeedbackTooltip = feedback;
        return this;
    }
}

