/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.widget;

import de.keksuccino.fancymenu.customization.widget.WidgetMeta;
import de.keksuccino.fancymenu.customization.widget.identification.WidgetIdentifierHandler;
import de.keksuccino.fancymenu.mixin.mixins.common.client.IMixinScreen;
import de.keksuccino.fancymenu.util.rendering.ui.screen.scrollnormalizer.ScrollScreenNormalizer;
import de.keksuccino.fancymenu.util.rendering.ui.widget.CustomizableWidget;
import de.keksuccino.konkrete.math.MathUtils;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import net.minecraft.class_310;
import net.minecraft.class_339;
import net.minecraft.class_350;
import net.minecraft.class_437;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class ScreenWidgetDiscoverer {
    private static final Logger LOGGER = LogManager.getLogger();

    @NotNull
    public static List<WidgetMeta> getWidgetsOfScreen(@NotNull class_437 screen) {
        return ScreenWidgetDiscoverer.getWidgetsOfScreen(screen, false);
    }

    @NotNull
    public static List<WidgetMeta> getWidgetsOfScreen(@NotNull class_437 screen, boolean updateScreenSize) {
        int newWidth = screen.field_22789;
        int newHeight = screen.field_22790;
        if (updateScreenSize) {
            newWidth = class_310.method_1551().method_22683().method_4486();
            newHeight = class_310.method_1551().method_22683().method_4502();
        }
        return ScreenWidgetDiscoverer.getWidgetsOfScreen(screen, newWidth, newHeight);
    }

    @NotNull
    public static List<WidgetMeta> getWidgetsOfScreen(@NotNull class_437 screen, int newWidth, int newHeight) {
        LinkedHashMap<Long, WidgetMeta> widgetMetas = new LinkedHashMap<Long, WidgetMeta>();
        try {
            List<WidgetMeta> ids = ScreenWidgetDiscoverer._getWidgetsOfScreen(screen, 1000, 1000);
            List<WidgetMeta> buttons = ScreenWidgetDiscoverer._getWidgetsOfScreen(screen, newWidth, newHeight);
            if (buttons.size() == ids.size()) {
                int i = 0;
                for (WidgetMeta id : ids) {
                    WidgetMeta button = buttons.get(i);
                    if (!widgetMetas.containsKey(id.getLongIdentifier())) {
                        widgetMetas.put(id.getLongIdentifier(), new WidgetMeta(button.getWidget(), id.getLongIdentifier(), screen));
                    } else {
                        LOGGER.warn("[FANCYMENU] Duplicate widget ID found while discovering screen widgets: " + id.getLongIdentifier(), (Throwable)new IllegalStateException("There can't be multiple widgets with the same identifier!"));
                    }
                    ++i;
                }
            }
            ArrayList<String> universalIdentifiers = new ArrayList<String>();
            for (WidgetMeta meta : widgetMetas.values()) {
                WidgetIdentifierHandler.setUniversalIdentifierOfWidgetMeta(meta);
                if (universalIdentifiers.contains(meta.getUniversalIdentifier())) {
                    meta.setUniversalIdentifier(null);
                    continue;
                }
                universalIdentifiers.add(meta.getUniversalIdentifier());
            }
        }
        catch (Exception ex) {
            LOGGER.error("[FANCYMENU] Failed to get widgets of screen!", (Throwable)ex);
        }
        return new ArrayList<WidgetMeta>(widgetMetas.values());
    }

    @NotNull
    private static List<WidgetMeta> _getWidgetsOfScreen(@NotNull class_437 screen, int screenWidth, int screenHeight) {
        ArrayList<WidgetMeta> widgetMetaList = new ArrayList<WidgetMeta>();
        ArrayList ids = new ArrayList();
        try {
            ((IMixinScreen)screen).getRenderablesFancyMenu().forEach(renderable -> {
                if (renderable instanceof CustomizableWidget) {
                    CustomizableWidget w = (CustomizableWidget)renderable;
                    w.resetWidgetCustomizationsFancyMenu();
                }
            });
            if (!((IMixinScreen)screen).get_initialized_FancyMenu()) {
                screen.method_25423(screenWidth, screenHeight);
            } else {
                screen.method_25410(screenWidth, screenHeight);
            }
            ScrollScreenNormalizer.normalizeScrollableScreen(screen);
            ((IMixinScreen)screen).getRenderablesFancyMenu().forEach(renderable -> ScreenWidgetDiscoverer.visitWidget(renderable, ids, widgetMetaList, screen));
        }
        catch (Exception ex) {
            LOGGER.error("[FANCYMENU] Failed to get widgets of screen!", (Throwable)ex);
        }
        return widgetMetaList;
    }

    private static void visitWidget(@NotNull Object widget, @NotNull List<Long> ids, @NotNull List<WidgetMeta> widgetMetaList, @NotNull class_437 screen) {
        if (widget instanceof class_339) {
            class_339 w = (class_339)widget;
            if (widget instanceof class_350) {
                return;
            }
            long id = ScreenWidgetDiscoverer.generateAvailableIdFromBaseId(ScreenWidgetDiscoverer.generateBaseId(w), ids);
            ids.add(id);
            widgetMetaList.add(new WidgetMeta(w, id, screen));
        }
    }

    private static long generateBaseId(@NotNull class_339 widget) {
        String s = "" + Math.abs(widget.method_46426()) + Math.abs(widget.method_46427());
        if (!MathUtils.isLong((String)s)) {
            LOGGER.error("[FANCYMENU] Widget ID is not a Long!", (Throwable)new NumberFormatException("Failed to parse widget identifier to Long!"));
            return 0L;
        }
        return Long.parseLong(s);
    }

    private static long generateAvailableIdFromBaseId(long baseId, @NotNull List<Long> ids) {
        if (ids.contains(baseId)) {
            String newId = baseId + "1";
            if (MathUtils.isLong((String)newId)) {
                return ScreenWidgetDiscoverer.generateAvailableIdFromBaseId(Long.parseLong(newId), ids);
            }
            LOGGER.error("[FANCYMENU] Widget ID is not a Long!", (Throwable)new NumberFormatException("Failed to parse widget identifier to Long!"));
        }
        return baseId;
    }
}

