/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.loadingrequirement.requirements.world.player;

import de.keksuccino.fancymenu.customization.loadingrequirement.LoadingRequirement;
import de.keksuccino.fancymenu.customization.loadingrequirement.internal.LoadingRequirementInstance;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.fancymenu.util.rendering.ui.UIBase;
import de.keksuccino.fancymenu.util.rendering.ui.screen.CellScreen;
import de.keksuccino.fancymenu.util.rendering.ui.screen.StringBuilderScreen;
import de.keksuccino.fancymenu.util.rendering.ui.screen.texteditor.TextEditorFormattingRule;
import de.keksuccino.fancymenu.util.rendering.ui.widget.editbox.EditBoxSuggestions;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.class_1074;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_638;
import net.minecraft.class_746;
import net.minecraft.class_7924;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class IsPlayerInDimensionRequirement
extends LoadingRequirement {
    private static final Logger LOGGER = LogManager.getLogger();

    public IsPlayerInDimensionRequirement() {
        super("is_player_in_dimension");
    }

    @Override
    public boolean canRunAsync() {
        return false;
    }

    @Override
    public boolean hasValue() {
        return true;
    }

    @Override
    public boolean isRequirementMet(@Nullable String value) {
        try {
            if (value == null || value.trim().isEmpty()) {
                return false;
            }
            class_638 level = class_310.method_1551().field_1687;
            class_746 player = class_310.method_1551().field_1724;
            if (level != null && player != null) {
                return value.equals(level.method_27983().method_29177().toString());
            }
        }
        catch (Exception ex) {
            LOGGER.error("[FANCYMENU] Failed to handle '" + this.getIdentifier() + "' loading requirement!", (Throwable)ex);
        }
        return false;
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return class_1074.method_4662((String)"fancymenu.requirements.world.is_player_in_dimension", (Object[])new Object[0]);
    }

    @Override
    public List<String> getDescription() {
        return List.of(LocalizationUtils.splitLocalizedStringLines("fancymenu.requirements.world.is_player_in_dimension.desc", new String[0]));
    }

    @Override
    public String getCategory() {
        return class_1074.method_4662((String)"fancymenu.requirements.categories.world", (Object[])new Object[0]);
    }

    @Override
    public String getValueDisplayName() {
        return class_1074.method_4662((String)"fancymenu.requirements.world.is_player_in_dimension.value", (Object[])new Object[0]);
    }

    @Override
    public String getValuePreset() {
        return "minecraft:overworld";
    }

    @Override
    public List<TextEditorFormattingRule> getValueFormattingRules() {
        return null;
    }

    @Override
    public void editValue(@NotNull class_437 parentScreen, @NotNull LoadingRequirementInstance requirementInstance) {
        IsPlayerInDimensionValueConfigScreen s = new IsPlayerInDimensionValueConfigScreen(Objects.requireNonNullElse(requirementInstance.value, this.getValuePreset()), callback -> {
            if (callback != null) {
                requirementInstance.value = callback;
            }
            class_310.method_1551().method_1507(parentScreen);
        });
        class_310.method_1551().method_1507((class_437)s);
    }

    @NotNull
    private static List<class_2960> getDimensionTypes() {
        ArrayList<class_2960> types = new ArrayList<class_2960>();
        try {
            class_638 level = class_310.method_1551().field_1687;
            if (level != null) {
                level.method_30349().method_30530(class_7924.field_41241).method_46754().forEach(dimensionTypeResourceKey -> types.add(dimensionTypeResourceKey.method_29177()));
            }
        }
        catch (Exception ex) {
            LOGGER.error("[FANCYMENU] Failed to get dimension types for 'Is Player In Dimension' loading requirement!", (Throwable)ex);
        }
        return types;
    }

    public static class IsPlayerInDimensionValueConfigScreen
    extends StringBuilderScreen {
        @NotNull
        protected String value;
        protected CellScreen.TextInputCell textInput;
        protected EditBoxSuggestions suggestions;

        protected IsPlayerInDimensionValueConfigScreen(@NotNull String value, @NotNull Consumer<String> callback) {
            super((class_2561)class_2561.method_43471((String)"fancymenu.elements.requirements.edit_value"), callback);
            this.value = value;
        }

        @Override
        protected void initCells() {
            this.addSpacerCell(20);
            String id = this.getValueString();
            this.addLabelCell((class_2561)class_2561.method_43471((String)"fancymenu.requirements.world.is_player_in_dimension.value"));
            this.textInput = this.addTextInputCell(null, true, true).setText(id);
            this.addCellGroupEndSpacerCell();
            ArrayList<String> suggestionValues = new ArrayList<String>();
            IsPlayerInDimensionRequirement.getDimensionTypes().forEach(location -> suggestionValues.add(location.toString()));
            if (suggestionValues.isEmpty()) {
                suggestionValues.add(class_1074.method_4662((String)"fancymenu.requirements.world.is_player_in_dimension.suggestions.error", (Object[])new Object[0]));
            }
            this.suggestions = EditBoxSuggestions.createWithCustomSuggestions(this, this.textInput.editBox, EditBoxSuggestions.SuggestionsRenderPosition.ABOVE_EDIT_BOX, suggestionValues);
            UIBase.applyDefaultWidgetSkinTo(this.suggestions);
            this.textInput.editBox.method_1863(s -> this.suggestions.method_23934());
            this.addSpacerCell(20);
        }

        @Override
        public void method_25394(@NotNull class_332 graphics, int mouseX, int mouseY, float partial) {
            super.method_25394(graphics, mouseX, mouseY, partial);
            this.suggestions.method_23923(graphics, mouseX, mouseY);
        }

        @Override
        public boolean method_25404(class_11908 event) {
            if (this.suggestions.method_23924(event)) {
                return true;
            }
            return super.method_25404(event);
        }

        public boolean method_25401(double $$0, double $$1, double scrollDeltaX, double scrollDeltaY) {
            if (this.suggestions.method_23921(scrollDeltaY)) {
                return true;
            }
            return super.method_25401($$0, $$1, scrollDeltaX, scrollDeltaY);
        }

        @Override
        public boolean method_25402(class_11909 event, boolean isDoubleClick) {
            if (this.suggestions.method_23922(event)) {
                return true;
            }
            return super.method_25402(event, isDoubleClick);
        }

        @Override
        @NotNull
        public String buildString() {
            return this.getValueString();
        }

        @NotNull
        protected String getValueString() {
            if (this.textInput != null) {
                return this.textInput.getText();
            }
            return this.value;
        }
    }
}

