/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.loadingrequirement;

import de.keksuccino.fancymenu.customization.loadingrequirement.LoadingRequirement;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LoadingRequirementRegistry {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final LinkedHashMap<String, LoadingRequirement> REQUIREMENTS = new LinkedHashMap();

    public static void register(@NotNull LoadingRequirement requirement) {
        if (REQUIREMENTS.containsKey(Objects.requireNonNull(requirement.getIdentifier()))) {
            LOGGER.warn("[FANCYMENU] A LoadingRequirement with the identifier '" + requirement.getIdentifier() + "' is already registered! Overriding requirement!");
        }
        REQUIREMENTS.put(requirement.getIdentifier(), requirement);
    }

    @NotNull
    public static List<LoadingRequirement> getRequirements() {
        ArrayList<LoadingRequirement> l = new ArrayList<LoadingRequirement>();
        REQUIREMENTS.forEach((key, value) -> l.add((LoadingRequirement)value));
        return l;
    }

    @Nullable
    public static LoadingRequirement getRequirement(@NotNull String requirementIdentifier) {
        return REQUIREMENTS.get(requirementIdentifier);
    }

    @NotNull
    public static LinkedHashMap<String, List<LoadingRequirement>> getRequirementsOrderedByCategories() {
        LinkedHashMap<String, List<LoadingRequirement>> m = new LinkedHashMap<String, List<LoadingRequirement>>();
        for (LoadingRequirement r : LoadingRequirementRegistry.getRequirements()) {
            if (r.getCategory() == null) continue;
            if (!m.containsKey(r.getCategory())) {
                m.put(r.getCategory(), new ArrayList());
            }
            m.get(r.getCategory()).add(r);
        }
        return m;
    }

    @NotNull
    public static List<LoadingRequirement> getRequirementsWithoutCategory() {
        ArrayList<LoadingRequirement> l = new ArrayList<LoadingRequirement>();
        for (LoadingRequirement r : LoadingRequirementRegistry.getRequirements()) {
            if (r.getCategory() != null) continue;
            l.add(r);
        }
        return l;
    }
}

