/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.listener.listeners.helpers;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import de.keksuccino.fancymenu.util.CloseableUtils;
import de.keksuccino.fancymenu.util.file.FileUtils;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import net.minecraft.class_1111;
import net.minecraft.class_1144;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MusicTrackInfoHelper {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final class_2960 MUSIC_TRACK_METADATA_LOCATION = class_2960.method_60655((String)"fancymenu", (String)"metadata/minecraft_music_tracks.json");
    private static final Gson GSON = new GsonBuilder().create();
    private static final Type MUSIC_TRACK_INFO_TYPE = new TypeToken<List<MusicTrackInfo>>(){}.getType();
    private static String cachedMusicTrackMetadataJsonString;
    private static List<MusicTrackInfo> cachedMusicTrackInfo;

    private MusicTrackInfoHelper() {
    }

    @NotNull
    public static List<MusicTrackInfo> getInfoForAllMusicTracks() {
        if (cachedMusicTrackInfo == null) {
            try {
                String json = MusicTrackInfoHelper.getMusicTrackMetadataString();
                List<MusicTrackInfo> parsed = (List<MusicTrackInfo>)GSON.fromJson(json, MUSIC_TRACK_INFO_TYPE);
                if (parsed == null) {
                    parsed = Collections.emptyList();
                }
                parsed.forEach(MusicTrackInfo::initialize);
                cachedMusicTrackInfo = Collections.unmodifiableList(parsed);
            }
            catch (Exception ex) {
                LOGGER.error("[FANCYMENU] Failed to parse Minecraft music track metadata!", (Throwable)ex);
                cachedMusicTrackInfo = Collections.emptyList();
            }
        }
        return cachedMusicTrackInfo;
    }

    @Nullable
    public static MusicTrackInfo findTrackInfo(@Nullable String trackIdentifier, @Nullable String eventIdentifier) {
        String normalizedTrack = MusicTrackInfoHelper.normalizeIdentifier(trackIdentifier);
        String normalizedEvent = MusicTrackInfoHelper.normalizeEventIdentifier(eventIdentifier);
        MusicTrackInfo fallback = null;
        for (MusicTrackInfo info : MusicTrackInfoHelper.getInfoForAllMusicTracks()) {
            if (info.matchesTrack(normalizedTrack)) {
                return info;
            }
            if (fallback != null || !info.matchesEvent(normalizedEvent)) continue;
            fallback = info;
        }
        return fallback;
    }

    @Nullable
    public static String extractTrackIdentifier(@Nullable class_1111 sound) {
        if (sound == null || sound == class_1144.field_5592 || sound == class_1144.field_42936) {
            return null;
        }
        class_2960 path = sound.method_4766();
        if (path != null) {
            return path.toString();
        }
        class_2960 fallback = sound.method_4767();
        return fallback != null ? fallback.toString() : null;
    }

    @NotNull
    private static String getMusicTrackMetadataString() {
        if (cachedMusicTrackMetadataJsonString != null) {
            return cachedMusicTrackMetadataJsonString;
        }
        InputStream in = null;
        try {
            in = class_310.method_1551().method_1478().getResourceOrThrow(MUSIC_TRACK_METADATA_LOCATION).method_14482();
            StringBuilder builder = new StringBuilder();
            FileUtils.readTextLinesFrom(in).forEach(line -> builder.append((String)line).append('\n'));
            cachedMusicTrackMetadataJsonString = builder.toString();
        }
        catch (Exception ex) {
            cachedMusicTrackMetadataJsonString = "";
            LOGGER.error("[FANCYMENU] Failed to read Minecraft music track metadata from file!", (Throwable)ex);
        }
        CloseableUtils.closeQuietly(in);
        return cachedMusicTrackMetadataJsonString;
    }

    private static String normalizeIdentifier(@Nullable String location) {
        if (location == null) {
            return null;
        }
        String value = location.replace('\\', '/').trim();
        if (value.isEmpty()) {
            return null;
        }
        value = MusicTrackInfoHelper.stripPrefix(value, "minecraft:");
        value = MusicTrackInfoHelper.stripPrefix(value, "assets/");
        value = MusicTrackInfoHelper.stripPrefix(value, "minecraft/");
        if ((value = MusicTrackInfoHelper.stripPrefix(value, "sounds/")).startsWith("/")) {
            value = value.substring(1);
        }
        return value.toLowerCase(Locale.ROOT);
    }

    private static String normalizeEventIdentifier(@Nullable String location) {
        if (location == null) {
            return null;
        }
        String value = location.trim();
        if (value.isEmpty()) {
            return null;
        }
        if (value.startsWith("minecraft:")) {
            value = value.substring("minecraft:".length());
        }
        value = value.replace('.', '/');
        return value.toLowerCase(Locale.ROOT);
    }

    private static String stripPrefix(String value, String prefix) {
        return value.startsWith(prefix) ? value.substring(prefix.length()) : value;
    }

    public static final class MusicTrackInfo {
        public String resource_location;
        public String display_name;
        public String artist;
        public String duration;
        private String normalizedResourcePath;
        private long durationMillis;

        private void initialize() {
            this.normalizedResourcePath = MusicTrackInfoHelper.normalizeIdentifier(this.resource_location);
            this.durationMillis = MusicTrackInfo.parseDurationMillis(this.duration);
            if (this.display_name == null || this.display_name.isBlank()) {
                this.display_name = "Unknown";
            }
            if (this.artist == null || this.artist.isBlank()) {
                this.artist = "Unknown";
            }
        }

        public String getDisplayName() {
            return this.display_name;
        }

        public String getArtist() {
            return this.artist;
        }

        public long getDurationMillis() {
            return this.durationMillis;
        }

        public String getNormalizedResourcePath() {
            return this.normalizedResourcePath;
        }

        private boolean matchesTrack(@Nullable String normalizedTrack) {
            return normalizedTrack != null && this.normalizedResourcePath != null && this.normalizedResourcePath.equals(normalizedTrack);
        }

        private boolean matchesEvent(@Nullable String normalizedEvent) {
            return normalizedEvent != null && this.normalizedResourcePath != null && this.normalizedResourcePath.startsWith(normalizedEvent);
        }

        private static long parseDurationMillis(@Nullable String duration) {
            if (duration == null || duration.isBlank()) {
                return 0L;
            }
            String[] parts = duration.trim().split(":");
            long totalSeconds = 0L;
            try {
                for (String part : parts) {
                    totalSeconds = totalSeconds * 60L + Long.parseLong(part.trim());
                }
                return totalSeconds * 1000L;
            }
            catch (NumberFormatException ex) {
                LOGGER.warn("[FANCYMENU] Invalid duration value in music metadata: {}", (Object)duration, (Object)ex);
                return 0L;
            }
        }
    }
}

