/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.element.elements.text.v2;

import de.keksuccino.fancymenu.customization.element.AbstractElement;
import de.keksuccino.fancymenu.customization.element.editor.AbstractEditorElement;
import de.keksuccino.fancymenu.customization.element.elements.text.v2.TextElement;
import de.keksuccino.fancymenu.customization.layout.editor.LayoutEditorScreen;
import de.keksuccino.fancymenu.mixin.mixins.common.client.IMixinScreen;
import de.keksuccino.fancymenu.util.ListUtils;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.fancymenu.util.input.TextValidators;
import de.keksuccino.fancymenu.util.rendering.DrawableColor;
import de.keksuccino.fancymenu.util.rendering.text.markdown.MarkdownRenderer;
import de.keksuccino.fancymenu.util.rendering.ui.contextmenu.v2.ContextMenu;
import de.keksuccino.fancymenu.util.rendering.ui.tooltip.Tooltip;
import java.util.Arrays;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import org.jetbrains.annotations.NotNull;

public class TextEditorElement
extends AbstractEditorElement {
    public TextEditorElement(@NotNull AbstractElement element, @NotNull LayoutEditorScreen editor) {
        super(element, editor);
    }

    @Override
    public void init() {
        super.init();
        this.addCycleContextMenuEntryTo(this.rightClickMenu, "source_mode", Arrays.asList(TextElement.SourceMode.values()), TextEditorElement.class, consumes -> consumes.getElement().sourceMode, (textEditorElement, sourceMode) -> {
            textEditorElement.getElement().sourceMode = sourceMode;
            textEditorElement.getElement().setSource((TextElement.SourceMode)sourceMode, null);
        }, (menu, entry, switcherValue) -> switcherValue.getCycleComponent()).setTooltipSupplier((menu, entry) -> Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.elements.text.v2.source_mode.desc", new String[0])));
        ((ContextMenu.ClickableContextMenuEntry)((ContextMenu.ContextMenuEntry)this.addTextResourceChooserContextMenuEntryTo(this.rightClickMenu, "set_text_resource", TextEditorElement.class, null, consumes -> consumes.getElement().textResourceSupplier, (element, supplier) -> element.getElement().setSource(TextElement.SourceMode.RESOURCE, supplier.getSourceWithPrefix()), (class_2561)class_2561.method_43471((String)"fancymenu.elements.text.v2.source.choose"), false, null, true, true, true).setIcon(ContextMenu.IconFactory.getIcon("text"))).setIsVisibleSupplier((menu, entry) -> this.getElement().sourceMode == TextElement.SourceMode.RESOURCE)).setStackable(false);
        ((ContextMenu.ClickableContextMenuEntry)((ContextMenu.ContextMenuEntry)this.addStringInputContextMenuEntryTo(this.rightClickMenu, "set_text_content", TextEditorElement.class, consumes -> consumes.getElement().source, (textEditorElement, s) -> textEditorElement.getElement().setSource(TextElement.SourceMode.DIRECT, (String)s), null, true, true, (class_2561)class_2561.method_43471((String)"fancymenu.elements.text.v2.source.input"), false, null, null, null).setIcon(ContextMenu.IconFactory.getIcon("text"))).setIsVisibleSupplier((menu, entry) -> this.getElement().sourceMode == TextElement.SourceMode.DIRECT)).setStackable(false);
        this.rightClickMenu.addSeparatorEntry("text_separator_1");
        this.addToggleContextMenuEntryTo(this.rightClickMenu, "remove_html_breaks", TextEditorElement.class, consumes -> consumes.getElement().markdownRenderer.isRemoveHtmlBreaks(), (textEditorElement, aBoolean) -> textEditorElement.getElement().markdownRenderer.setRemoveHtmlBreaks((boolean)aBoolean), "fancymenu.elements.text.remove_html_breaks").setStackable(true);
        this.addGenericCycleContextMenuEntryTo(this.rightClickMenu, "set_case_mode", ListUtils.of(MarkdownRenderer.TextCase.NORMAL, MarkdownRenderer.TextCase.ALL_UPPER, MarkdownRenderer.TextCase.ALL_LOWER), consumes -> consumes instanceof TextEditorElement, consumes -> ((TextElement)consumes.element).markdownRenderer.getTextCase(), (element1, caseMode) -> ((TextElement)element1.element).markdownRenderer.setTextCase((MarkdownRenderer.TextCase)((Object)caseMode)), (menu, entry, switcherValue) -> {
            if (switcherValue == MarkdownRenderer.TextCase.NORMAL) {
                return class_2561.method_43471((String)"fancymenu.elements.text.case_mode.normal");
            }
            if (switcherValue == MarkdownRenderer.TextCase.ALL_LOWER) {
                return class_2561.method_43471((String)"fancymenu.elements.text.case_mode.lower");
            }
            return class_2561.method_43471((String)"fancymenu.elements.text.case_mode.upper");
        }).setIcon(ContextMenu.IconFactory.getIcon("text_size"));
        ((ContextMenu.ContextMenuEntry)this.addGenericFloatInputContextMenuEntryTo(this.rightClickMenu, "set_scale", consumes -> consumes instanceof TextEditorElement, consumes -> Float.valueOf(((TextElement)consumes.element).markdownRenderer.getTextBaseScale()), (element1, aFloat) -> {
            ((TextElement)element1.element).markdownRenderer.setTextBaseScale(Math.max(0.2f, aFloat.floatValue()));
            ((TextElement)element1.element).updateContent();
        }, (class_2561)class_2561.method_43471((String)"fancymenu.elements.text.scale"), true, 1.0f, null, null).setIcon(ContextMenu.IconFactory.getIcon("measure"))).setStackable(true);
        ((ContextMenu.ClickableContextMenuEntry)this.addToggleContextMenuEntryTo(this.rightClickMenu, "set_shadow", TextEditorElement.class, consumes -> consumes.getElement().markdownRenderer.isTextShadow(), (textEditorElement, aBoolean) -> textEditorElement.getElement().markdownRenderer.setTextShadow((boolean)aBoolean), "fancymenu.elements.text.shadow").setStackable(true)).setIcon(ContextMenu.IconFactory.getIcon("shadow"));
        ((ContextMenu.ClickableContextMenuEntry)this.addGenericStringInputContextMenuEntryTo(this.rightClickMenu, "set_base_color", consumes -> consumes instanceof TextEditorElement, consumes -> ((TextElement)consumes.element).markdownRenderer.getTextBaseColor().getHex(), (element, colorHex) -> ((TextElement)element.element).markdownRenderer.setTextBaseColor(DrawableColor.of(colorHex)), null, false, false, (class_2561)class_2561.method_43471((String)"fancymenu.elements.text.base_color"), true, DrawableColor.WHITE.getHex(), TextValidators.HEX_COLOR_TEXT_VALIDATOR, null).setStackable(true)).setTooltipSupplier((menu, entry) -> Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.elements.text.base_color.desc", new String[0])));
        ((ContextMenu.ClickableContextMenuEntry)this.addGenericIntegerInputContextMenuEntryTo(this.rightClickMenu, "set_border", consumes -> consumes instanceof TextEditorElement, consumes -> (int)((TextElement)consumes.element).markdownRenderer.getBorder(), (element, border) -> ((TextElement)element.element).markdownRenderer.setBorder(Math.max(0, border)), (class_2561)class_2561.method_43471((String)"fancymenu.elements.text.text_border"), true, 2, null, null).setStackable(true)).setTooltipSupplier((menu, entry) -> Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.elements.text.text_border.desc", new String[0])));
        this.addGenericIntegerInputContextMenuEntryTo(this.rightClickMenu, "set_line_spacing", consumes -> consumes instanceof TextEditorElement, consumes -> (int)((TextElement)consumes.element).markdownRenderer.getLineSpacing(), (element, border) -> ((TextElement)element.element).markdownRenderer.setLineSpacing(Math.max(0, border)), (class_2561)class_2561.method_43471((String)"fancymenu.elements.text.line_spacing"), true, 2, null, null).setStackable(true);
        this.addToggleContextMenuEntryTo(this.rightClickMenu, "auto_line_wrapping", TextEditorElement.class, consumes -> consumes.getElement().markdownRenderer.isAutoLineBreakingEnabled(), (textEditorElement, aBoolean) -> textEditorElement.getElement().markdownRenderer.setAutoLineBreakingEnabled((boolean)aBoolean), "fancymenu.elements.text.auto_line_wrapping").setStackable(true);
        this.rightClickMenu.addSeparatorEntry("separator_after_line_wrapping").setStackable(true);
        ContextMenu markdownMenu = new ContextMenu();
        this.rightClickMenu.addSubMenuEntry("markdown", (class_2561)class_2561.method_43471((String)"fancymenu.elements.text.markdown"), markdownMenu).setStackable(true);
        this.addToggleContextMenuEntryTo(markdownMenu, "parse_markdown", TextEditorElement.class, consumes -> consumes.getElement().markdownRenderer.isParseMarkdown(), (textEditorElement, aBoolean) -> textEditorElement.getElement().markdownRenderer.setParseMarkdown((boolean)aBoolean), "fancymenu.elements.text.markdown.toggle").setTooltipSupplier((menu, entry) -> Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.elements.text.markdown.toggle.desc", new String[0])));
        markdownMenu.addSeparatorEntry("separator_after_parse_markdown");
        this.addStringInputContextMenuEntryTo(markdownMenu, "code_block_single_line_color", TextEditorElement.class, consumes -> consumes.getElement().markdownRenderer.getCodeBlockSingleLineColor().getHex(), (textEditorElement, s) -> textEditorElement.getElement().markdownRenderer.setCodeBlockSingleLineColor(DrawableColor.of(s)), null, false, false, (class_2561)class_2561.method_43471((String)"fancymenu.elements.text.markdown.code_block.single.color"), true, DrawableColor.of(115, 115, 115).getHex(), TextValidators.HEX_COLOR_TEXT_VALIDATOR, null).setStackable(true);
        this.addStringInputContextMenuEntryTo(markdownMenu, "code_block_multi_line_color", TextEditorElement.class, consumes -> consumes.getElement().markdownRenderer.getCodeBlockMultiLineColor().getHex(), (textEditorElement, s) -> textEditorElement.getElement().markdownRenderer.setCodeBlockMultiLineColor(DrawableColor.of(s)), null, false, false, (class_2561)class_2561.method_43471((String)"fancymenu.elements.text.markdown.code_block.multi.color"), true, DrawableColor.of(86, 86, 86).getHex(), TextValidators.HEX_COLOR_TEXT_VALIDATOR, null).setStackable(true);
        markdownMenu.addSeparatorEntry("separator_after_code_block");
        this.addStringInputContextMenuEntryTo(markdownMenu, "headline_line_color", TextEditorElement.class, consumes -> consumes.getElement().markdownRenderer.getHeadlineUnderlineColor().getHex(), (textEditorElement, s) -> textEditorElement.getElement().markdownRenderer.setHeadlineLineColor(DrawableColor.of(s)), null, false, false, (class_2561)class_2561.method_43471((String)"fancymenu.elements.text.markdown.headline.line.color"), true, DrawableColor.of(169, 169, 169).getHex(), TextValidators.HEX_COLOR_TEXT_VALIDATOR, null).setStackable(true);
        markdownMenu.addSeparatorEntry("separator_after_headline");
        this.addStringInputContextMenuEntryTo(markdownMenu, "separation_line_color", TextEditorElement.class, consumes -> consumes.getElement().markdownRenderer.getSeparationLineColor().getHex(), (textEditorElement, s) -> textEditorElement.getElement().markdownRenderer.setSeparationLineColor(DrawableColor.of(s)), null, false, false, (class_2561)class_2561.method_43471((String)"fancymenu.elements.text.markdown.separation_line.color"), true, DrawableColor.of(169, 169, 169).getHex(), TextValidators.HEX_COLOR_TEXT_VALIDATOR, null).setStackable(true);
        markdownMenu.addSeparatorEntry("separator_after_separation_line");
        this.addStringInputContextMenuEntryTo(markdownMenu, "hyperlink_color", TextEditorElement.class, consumes -> consumes.getElement().markdownRenderer.getHyperlinkColor().getHex(), (textEditorElement, s) -> textEditorElement.getElement().markdownRenderer.setHyperlinkColor(DrawableColor.of(s)), null, false, false, (class_2561)class_2561.method_43471((String)"fancymenu.elements.text.markdown.hyperlink.color"), true, DrawableColor.of(7, 113, 252).getHex(), TextValidators.HEX_COLOR_TEXT_VALIDATOR, null).setStackable(true);
        markdownMenu.addSeparatorEntry("separator_after_hyperlink");
        this.addStringInputContextMenuEntryTo(markdownMenu, "quote_color", TextEditorElement.class, consumes -> consumes.getElement().markdownRenderer.getQuoteColor().getHex(), (textEditorElement, s) -> textEditorElement.getElement().markdownRenderer.setQuoteColor(DrawableColor.of(s)), null, false, false, (class_2561)class_2561.method_43471((String)"fancymenu.elements.text.markdown.quote.color"), true, DrawableColor.of(129, 129, 129).getHex(), TextValidators.HEX_COLOR_TEXT_VALIDATOR, null).setStackable(true);
        this.addIntegerInputContextMenuEntryTo(markdownMenu, "quote_indent", TextEditorElement.class, consumes -> (int)consumes.getElement().markdownRenderer.getQuoteIndent(), (textEditorElement, integer) -> textEditorElement.getElement().markdownRenderer.setQuoteIndent(integer.intValue()), (class_2561)class_2561.method_43471((String)"fancymenu.elements.text.markdown.quote.indent"), true, 8, null, null).setStackable(true);
        this.addToggleContextMenuEntryTo(markdownMenu, "quote_italic", TextEditorElement.class, consumes -> consumes.getElement().markdownRenderer.isQuoteItalic(), (textEditorElement, aBoolean) -> textEditorElement.getElement().markdownRenderer.setQuoteItalic((boolean)aBoolean), "fancymenu.elements.text.markdown.quote.italic").setStackable(true);
        markdownMenu.addSeparatorEntry("separator_after_quote");
        this.addStringInputContextMenuEntryTo(markdownMenu, "bullet_list_dot_color", TextEditorElement.class, consumes -> consumes.getElement().markdownRenderer.getBulletListDotColor().getHex(), (textEditorElement, s) -> textEditorElement.getElement().markdownRenderer.setBulletListDotColor(DrawableColor.of(s)), null, false, false, (class_2561)class_2561.method_43471((String)"fancymenu.elements.text.markdown.bullet_list.dot.color"), true, DrawableColor.of(169, 169, 169).getHex(), TextValidators.HEX_COLOR_TEXT_VALIDATOR, null).setStackable(true);
        this.addIntegerInputContextMenuEntryTo(markdownMenu, "bullet_list_indent", TextEditorElement.class, consumes -> (int)consumes.getElement().markdownRenderer.getBulletListIndent(), (textEditorElement, integer) -> textEditorElement.getElement().markdownRenderer.setBulletListIndent(integer.intValue()), (class_2561)class_2561.method_43471((String)"fancymenu.elements.text.markdown.bullet_list.indent"), true, 8, null, null).setStackable(true);
        this.addIntegerInputContextMenuEntryTo(markdownMenu, "bullet_list_spacing", TextEditorElement.class, consumes -> (int)consumes.getElement().markdownRenderer.getBulletListSpacing(), (textEditorElement, integer) -> textEditorElement.getElement().markdownRenderer.setBulletListSpacing(integer.intValue()), (class_2561)class_2561.method_43471((String)"fancymenu.elements.text.markdown.bullet_list.spacing"), true, 3, null, null).setStackable(true);
        markdownMenu.addSeparatorEntry("separator_after_bullet_list");
        ContextMenu tableMenu = new ContextMenu();
        ((ContextMenu.SubMenuContextMenuEntry)markdownMenu.addSubMenuEntry("tables", (class_2561)class_2561.method_43471((String)"fancymenu.elements.text.markdown.tables"), tableMenu).setTooltipSupplier((menu, entry) -> Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.elements.text.markdown.tables.desc", new String[0])))).setStackable(true);
        this.addToggleContextMenuEntryTo(tableMenu, "table_show_header", TextEditorElement.class, consumes -> consumes.getElement().markdownRenderer.isTableShowHeader(), (textEditorElement, aBoolean) -> textEditorElement.getElement().markdownRenderer.setTableShowHeader((boolean)aBoolean), "fancymenu.elements.text.markdown.tables.show_header").setStackable(true);
        this.addToggleContextMenuEntryTo(tableMenu, "table_alternate_row_colors", TextEditorElement.class, consumes -> consumes.getElement().markdownRenderer.isTableAlternateRowColors(), (textEditorElement, aBoolean) -> textEditorElement.getElement().markdownRenderer.setTableAlternateRowColors((boolean)aBoolean), "fancymenu.elements.text.markdown.tables.alternate_row_colors").setStackable(true);
        tableMenu.addSeparatorEntry("separator_after_table_toggles");
        this.addStringInputContextMenuEntryTo(tableMenu, "table_line_color", TextEditorElement.class, consumes -> consumes.getElement().markdownRenderer.getTableLineColor().getHex(), (textEditorElement, s) -> textEditorElement.getElement().markdownRenderer.setTableLineColor(DrawableColor.of(s)), null, false, false, (class_2561)class_2561.method_43471((String)"fancymenu.elements.text.markdown.tables.line_color"), true, DrawableColor.of(120, 120, 120).getHex(), TextValidators.HEX_COLOR_TEXT_VALIDATOR, null).setStackable(true);
        this.addStringInputContextMenuEntryTo(tableMenu, "table_header_background_color", TextEditorElement.class, consumes -> consumes.getElement().markdownRenderer.getTableHeaderBackgroundColor().getHex(), (textEditorElement, s) -> textEditorElement.getElement().markdownRenderer.setTableHeaderBackgroundColor(DrawableColor.of(s)), null, false, false, (class_2561)class_2561.method_43471((String)"fancymenu.elements.text.markdown.tables.header_background_color"), true, DrawableColor.of(50, 50, 50).getHex(), TextValidators.HEX_COLOR_TEXT_VALIDATOR, null).setStackable(true);
        this.addStringInputContextMenuEntryTo(tableMenu, "table_row_background_color", TextEditorElement.class, consumes -> consumes.getElement().markdownRenderer.getTableRowBackgroundColor().getHex(), (textEditorElement, s) -> textEditorElement.getElement().markdownRenderer.setTableRowBackgroundColor(DrawableColor.of(s)), null, false, false, (class_2561)class_2561.method_43471((String)"fancymenu.elements.text.markdown.tables.row_background_color"), true, DrawableColor.of(40, 40, 40).getHex(), TextValidators.HEX_COLOR_TEXT_VALIDATOR, null).setStackable(true);
        ((ContextMenu.ClickableContextMenuEntry)this.addStringInputContextMenuEntryTo(tableMenu, "table_alternate_row_color", TextEditorElement.class, consumes -> consumes.getElement().markdownRenderer.getTableAlternateRowColor().getHex(), (textEditorElement, s) -> textEditorElement.getElement().markdownRenderer.setTableAlternateRowColor(DrawableColor.of(s)), null, false, false, (class_2561)class_2561.method_43471((String)"fancymenu.elements.text.markdown.tables.alternate_row_color"), true, DrawableColor.of(60, 60, 60).getHex(), TextValidators.HEX_COLOR_TEXT_VALIDATOR, null).setStackable(true)).setTooltipSupplier((menu, entry) -> Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.elements.text.markdown.tables.alternate_row_color.desc", new String[0])));
        tableMenu.addSeparatorEntry("separator_after_table_colors");
        this.addFloatInputContextMenuEntryTo(tableMenu, "table_line_thickness", TextEditorElement.class, consumes -> Float.valueOf(consumes.getElement().markdownRenderer.getTableLineThickness()), (textEditorElement, aFloat) -> textEditorElement.getElement().markdownRenderer.setTableLineThickness(Math.max(0.5f, aFloat.floatValue())), (class_2561)class_2561.method_43471((String)"fancymenu.elements.text.markdown.tables.line_thickness"), true, 1.0f, null, null).setStackable(true);
        ((ContextMenu.ClickableContextMenuEntry)this.addFloatInputContextMenuEntryTo(tableMenu, "table_cell_padding", TextEditorElement.class, consumes -> Float.valueOf(consumes.getElement().markdownRenderer.getTableCellPadding()), (textEditorElement, aFloat) -> textEditorElement.getElement().markdownRenderer.setTableCellPadding(Math.max(0.0f, aFloat.floatValue())), (class_2561)class_2561.method_43471((String)"fancymenu.elements.text.markdown.tables.cell_padding"), true, 8.0f, null, null).setStackable(true)).setTooltipSupplier((menu, entry) -> Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.elements.text.markdown.tables.cell_padding.desc", new String[0])));
        ((ContextMenu.ClickableContextMenuEntry)this.addFloatInputContextMenuEntryTo(tableMenu, "table_margin", TextEditorElement.class, consumes -> Float.valueOf(consumes.getElement().markdownRenderer.getTableMargin()), (textEditorElement, aFloat) -> textEditorElement.getElement().markdownRenderer.setTableMargin(Math.max(0.0f, aFloat.floatValue())), (class_2561)class_2561.method_43471((String)"fancymenu.elements.text.markdown.tables.margin"), true, 4.0f, null, null).setStackable(true)).setTooltipSupplier((menu, entry) -> Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.elements.text.markdown.tables.margin.desc", new String[0])));
        this.rightClickMenu.addSeparatorEntry("separator_after_markdown");
        this.addToggleContextMenuEntryTo(this.rightClickMenu, "set_scrolling", TextEditorElement.class, consumes -> consumes.getElement().enableScrolling, (textEditorElement, aBoolean) -> {
            textEditorElement.getElement().enableScrolling = aBoolean;
        }, "fancymenu.elements.text.scrolling").setStackable(true);
        this.rightClickMenu.addSeparatorEntry("separator_after_scrolling");
        ContextMenu grabberTextureMenu = new ContextMenu();
        ((ContextMenu.SubMenuContextMenuEntry)this.rightClickMenu.addSubMenuEntry("grabber_texture", (class_2561)class_2561.method_43471((String)"fancymenu.elements.text.scroll_grabber_texture"), grabberTextureMenu).setStackable(true)).setIcon(ContextMenu.IconFactory.getIcon("image"));
        this.addImageResourceChooserContextMenuEntryTo(grabberTextureMenu, "vertical_normal_grabber_texture", TextEditorElement.class, null, consumes -> consumes.getElement().verticalScrollGrabberTextureNormal, (element, supplier) -> {
            element.getElement().verticalScrollGrabberTextureNormal = supplier;
        }, (class_2561)class_2561.method_43471((String)"fancymenu.elements.text.vertical_scroll_grabber_texture.normal"), true, null, true, true, true);
        this.addImageResourceChooserContextMenuEntryTo(grabberTextureMenu, "vertical_hover_grabber_texture", TextEditorElement.class, null, consumes -> consumes.getElement().verticalScrollGrabberTextureHover, (element, supplier) -> {
            element.getElement().verticalScrollGrabberTextureHover = supplier;
        }, (class_2561)class_2561.method_43471((String)"fancymenu.elements.text.vertical_scroll_grabber_texture.hover"), true, null, true, true, true);
        grabberTextureMenu.addSeparatorEntry("separator_after_vertical_textures");
        this.addImageResourceChooserContextMenuEntryTo(grabberTextureMenu, "horizontal_normal_grabber_texture", TextEditorElement.class, null, consumes -> consumes.getElement().horizontalScrollGrabberTextureNormal, (element, supplier) -> {
            element.getElement().horizontalScrollGrabberTextureNormal = supplier;
        }, (class_2561)class_2561.method_43471((String)"fancymenu.elements.text.horizontal_scroll_grabber_texture.normal"), true, null, true, true, true);
        this.addImageResourceChooserContextMenuEntryTo(grabberTextureMenu, "horizontal_hover_grabber_texture", TextEditorElement.class, null, consumes -> consumes.getElement().horizontalScrollGrabberTextureHover, (element, supplier) -> {
            element.getElement().horizontalScrollGrabberTextureHover = supplier;
        }, (class_2561)class_2561.method_43471((String)"fancymenu.elements.text.horizontal_scroll_grabber_texture.hover"), true, null, true, true, true);
        ContextMenu grabberColorMenu = new ContextMenu();
        ((ContextMenu.SubMenuContextMenuEntry)this.rightClickMenu.addSubMenuEntry("grabber_color", (class_2561)class_2561.method_43471((String)"fancymenu.elements.text.scroll_grabber_color"), grabberColorMenu).setStackable(true)).setTooltipSupplier((menu, entry) -> Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.elements.text.scroll_grabber_color.desc", new String[0])));
        this.addGenericStringInputContextMenuEntryTo(grabberColorMenu, "normal_grabber_color", consumes -> consumes instanceof TextEditorElement, consumes -> ((TextElement)consumes.element).scrollGrabberColorHexNormal, (element, colorHex) -> {
            ((TextElement)element.element).scrollGrabberColorHexNormal = colorHex;
        }, null, false, false, (class_2561)class_2561.method_43471((String)"fancymenu.elements.text.scroll_grabber_color.normal"), true, null, TextValidators.HEX_COLOR_TEXT_VALIDATOR, null).setStackable(true);
        this.addGenericStringInputContextMenuEntryTo(grabberColorMenu, "hover_grabber_color", consumes -> consumes instanceof TextEditorElement, consumes -> ((TextElement)consumes.element).scrollGrabberColorHexHover, (element, colorHex) -> {
            ((TextElement)element.element).scrollGrabberColorHexHover = colorHex;
        }, null, false, false, (class_2561)class_2561.method_43471((String)"fancymenu.elements.text.scroll_grabber_color.hover"), true, null, TextValidators.HEX_COLOR_TEXT_VALIDATOR, null).setStackable(true);
        this.rightClickMenu.addSeparatorEntry("separator_after_hover_grabber_color");
        this.addToggleContextMenuEntryTo(this.rightClickMenu, "interactable", TextEditorElement.class, consumes -> consumes.getElement().interactable, (textEditorElement, aBoolean) -> {
            textEditorElement.getElement().interactable = aBoolean;
        }, "fancymenu.elements.text.v2.interactable").setTooltipSupplier((menu, entry) -> Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.elements.text.v2.interactable.desc", new String[0])));
    }

    @Override
    public void method_25394(@NotNull class_332 graphics, int mouseX, int mouseY, float partial) {
        if (!this.editor.method_25396().contains(this.getElement().scrollArea)) {
            ((IMixinScreen)((Object)this.editor)).getChildrenFancyMenu().add(this.getElement().scrollArea);
        }
        super.method_25394(graphics, mouseX, mouseY, partial);
    }

    protected TextElement getElement() {
        return (TextElement)this.element;
    }
}

