/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.element.elements.progressbar;

import de.keksuccino.fancymenu.customization.element.AbstractElement;
import de.keksuccino.fancymenu.customization.element.ElementBuilder;
import de.keksuccino.fancymenu.customization.placeholder.PlaceholderParser;
import de.keksuccino.fancymenu.util.enums.LocalizedCycleEnum;
import de.keksuccino.fancymenu.util.rendering.DrawableColor;
import de.keksuccino.fancymenu.util.resource.ResourceSupplier;
import de.keksuccino.fancymenu.util.resource.resources.texture.ITexture;
import de.keksuccino.konkrete.math.MathUtils;
import java.awt.Color;
import net.minecraft.class_10799;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_9848;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProgressBarElement
extends AbstractElement {
    private static final Logger LOGGER = LogManager.getLogger();
    public BarDirection direction = BarDirection.RIGHT;
    public DrawableColor barColor = DrawableColor.of(new Color(82, 149, 255));
    @Nullable
    public ResourceSupplier<ITexture> barTextureSupplier;
    public DrawableColor backgroundColor = DrawableColor.of(new Color(171, 200, 247));
    @Nullable
    public ResourceSupplier<ITexture> backgroundTextureSupplier;
    public boolean useProgressForElementAnchor = false;
    public String progressSource = null;
    public ProgressValueMode progressValueMode = ProgressValueMode.PERCENTAGE;
    public boolean smoothFillingAnimation = true;
    protected int lastRenderedProgressX = 0;
    protected int lastRenderedProgressY = 0;
    protected int lastRenderedProgressWidth = 0;
    protected int lastRenderedProgressHeight = 0;

    public ProgressBarElement(@NotNull ElementBuilder<?, ?> builder) {
        super(builder);
        this.allowDepthTestManipulation = true;
    }

    @Override
    public void method_25394(@NotNull class_332 graphics, int mouseX, int mouseY, float partial) {
        if (!this.shouldRender()) {
            return;
        }
        this.renderBackground(graphics);
        this.renderProgress(graphics);
    }

    protected void renderProgress(@NotNull class_332 graphics) {
        float targetProgress = Math.max(0.0f, Math.min(1.0f, this.getCurrentProgress()));
        float smoothedProgress = this.getSmoothedProgress();
        if (!this.smoothFillingAnimation) {
            smoothedProgress = targetProgress;
        } else if (Math.abs((smoothedProgress = class_3532.method_15363((float)(smoothedProgress * 0.95f + targetProgress * 0.05f), (float)0.0f, (float)1.0f)) - targetProgress) < 0.001f) {
            smoothedProgress = targetProgress;
        }
        int fullWidth = this.getAbsoluteWidth();
        int fullHeight = this.getAbsoluteHeight();
        int progressX = this.getAbsoluteX();
        int progressY = this.getAbsoluteY();
        float offsetX = 0.0f;
        float offsetY = 0.0f;
        int progressWidth = fullWidth;
        int progressHeight = fullHeight;
        if (this.direction == BarDirection.LEFT || this.direction == BarDirection.RIGHT) {
            progressWidth = (int)((float)fullWidth * smoothedProgress);
            if (targetProgress == 1.0f && (float)progressWidth >= (float)fullWidth - (float)fullWidth * 0.01f) {
                progressWidth = fullWidth;
            }
        }
        if (this.direction == BarDirection.UP || this.direction == BarDirection.DOWN) {
            progressHeight = (int)((float)fullHeight * smoothedProgress);
            if (targetProgress == 1.0f && (float)progressHeight >= (float)fullHeight - (float)fullHeight * 0.01f) {
                progressHeight = fullHeight;
            }
        }
        if (this.direction == BarDirection.LEFT) {
            progressX += fullWidth - progressWidth;
            offsetX = fullWidth - progressWidth;
        }
        if (this.direction == BarDirection.UP) {
            progressY += fullHeight - progressHeight;
            offsetY = fullHeight - progressHeight;
        }
        this.lastRenderedProgressX = progressX;
        this.lastRenderedProgressY = progressY;
        this.lastRenderedProgressWidth = progressWidth;
        this.lastRenderedProgressHeight = progressHeight;
        if (this.barTextureSupplier != null) {
            class_2960 loc;
            ITexture texture = this.barTextureSupplier.get();
            if (texture != null && (loc = texture.getIdentifier()) != null) {
                graphics.method_25291(class_10799.field_56883, loc, progressX, progressY, offsetX, offsetY, progressWidth, progressHeight, fullWidth, fullHeight, DrawableColor.WHITE.getColorIntWithAlpha(this.opacity));
            }
        } else if (this.barColor != null) {
            float colorAlpha = Math.min(1.0f, Math.max(0.0f, (float)class_9848.method_61320((int)this.barColor.getColorInt()) / 255.0f));
            if (this.opacity <= colorAlpha) {
                colorAlpha = this.opacity;
            }
            graphics.method_25294(progressX, progressY, progressX + progressWidth, progressY + progressHeight, this.barColor.getColorIntWithAlpha(colorAlpha));
        }
        this.setSmoothedProgress(smoothedProgress);
    }

    protected void renderBackground(@NotNull class_332 graphics) {
        if (this.backgroundTextureSupplier != null) {
            this.backgroundTextureSupplier.forRenderable((texture, location) -> graphics.method_25291(class_10799.field_56883, location, this.getAbsoluteX(), this.getAbsoluteY(), 0.0f, 0.0f, this.getAbsoluteWidth(), this.getAbsoluteHeight(), this.getAbsoluteWidth(), this.getAbsoluteHeight(), DrawableColor.WHITE.getColorIntWithAlpha(this.opacity)));
        } else if (this.backgroundColor != null) {
            float colorAlpha = Math.min(1.0f, Math.max(0.0f, (float)class_9848.method_61320((int)this.backgroundColor.getColorInt()) / 255.0f));
            if (this.opacity <= colorAlpha) {
                colorAlpha = this.opacity;
            }
            graphics.method_25294(this.getAbsoluteX(), this.getAbsoluteY(), this.getAbsoluteX() + this.getAbsoluteWidth(), this.getAbsoluteY() + this.getAbsoluteHeight(), this.backgroundColor.getColorIntWithAlpha(colorAlpha));
        }
    }

    public float getCurrentProgress() {
        String progressString;
        if (ProgressBarElement.isEditor()) {
            return 0.5f;
        }
        if (this.progressSource != null && MathUtils.isFloat((String)(progressString = StringUtils.replace((String)PlaceholderParser.replacePlaceholders(this.progressSource), (String)" ", (String)"")))) {
            if (this.progressValueMode == ProgressValueMode.PERCENTAGE) {
                return Float.parseFloat(progressString) / 100.0f;
            }
            return Float.parseFloat(progressString);
        }
        return 0.0f;
    }

    @Override
    public int getChildElementAnchorPointX() {
        if (this.useProgressForElementAnchor) {
            if (this.direction == BarDirection.RIGHT) {
                return this.getProgressX() + this.getProgressWidth();
            }
            return this.getProgressX();
        }
        return super.getChildElementAnchorPointX();
    }

    @Override
    public int getChildElementAnchorPointY() {
        if (this.useProgressForElementAnchor) {
            if (this.direction == BarDirection.DOWN) {
                return this.getProgressY() + this.getProgressHeight();
            }
            return this.getProgressY();
        }
        return super.getChildElementAnchorPointY();
    }

    public int getProgressX() {
        return this.lastRenderedProgressX;
    }

    public int getProgressY() {
        return this.lastRenderedProgressY;
    }

    public int getProgressWidth() {
        return this.lastRenderedProgressWidth;
    }

    public int getProgressHeight() {
        return this.lastRenderedProgressHeight;
    }

    protected float getSmoothedProgress() {
        Float f = this.getMemory().getProperty("smoothed_progress", Float.class);
        if (f == null) {
            f = Float.valueOf(0.0f);
        }
        return f.floatValue();
    }

    protected void setSmoothedProgress(float progress) {
        this.getMemory().putProperty("smoothed_progress", Float.valueOf(progress));
    }

    public static enum BarDirection implements LocalizedCycleEnum<BarDirection>
    {
        LEFT("left"),
        RIGHT("right"),
        UP("up"),
        DOWN("down");

        private final String name;

        private BarDirection(String name) {
            this.name = name;
        }

        @Override
        @NotNull
        public String getLocalizationKeyBase() {
            return "fancymenu.elements.progress_bar.direction";
        }

        @Override
        @NotNull
        public class_2583 getValueComponentStyle() {
            return (class_2583)WARNING_TEXT_STYLE.get();
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        @NotNull
        public BarDirection[] getValues() {
            return BarDirection.values();
        }

        @Override
        @Nullable
        public BarDirection getByNameInternal(@NotNull String name) {
            return BarDirection.getByName(name);
        }

        @Nullable
        public static BarDirection getByName(@NotNull String name) {
            for (BarDirection d : BarDirection.values()) {
                if (!d.name.equals(name)) continue;
                return d;
            }
            return null;
        }
    }

    public static enum ProgressValueMode implements LocalizedCycleEnum<ProgressValueMode>
    {
        PERCENTAGE("percentage"),
        FLOATING_POINT("float");

        private final String name;

        private ProgressValueMode(String name) {
            this.name = name;
        }

        @Override
        @NotNull
        public String getLocalizationKeyBase() {
            return "fancymenu.elements.progress_bar.mode";
        }

        @Override
        @NotNull
        public class_2583 getValueComponentStyle() {
            return (class_2583)WARNING_TEXT_STYLE.get();
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        @NotNull
        public ProgressValueMode[] getValues() {
            return ProgressValueMode.values();
        }

        @Override
        @Nullable
        public ProgressValueMode getByNameInternal(@NotNull String name) {
            return ProgressValueMode.getByName(name);
        }

        @Nullable
        public static ProgressValueMode getByName(@NotNull String name) {
            for (ProgressValueMode d : ProgressValueMode.values()) {
                if (!d.name.equals(name)) continue;
                return d;
            }
            return null;
        }
    }
}

