/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.element.elements.playerentity;

import de.keksuccino.fancymenu.customization.element.AbstractElement;
import de.keksuccino.fancymenu.customization.element.ElementBuilder;
import de.keksuccino.fancymenu.customization.element.elements.playerentity.textures.CapeResourceSupplier;
import de.keksuccino.fancymenu.customization.element.elements.playerentity.textures.SkinResourceSupplier;
import de.keksuccino.fancymenu.customization.placeholder.PlaceholderParser;
import de.keksuccino.fancymenu.util.SerializationUtils;
import de.keksuccino.fancymenu.util.enums.LocalizedCycleEnum;
import de.keksuccino.fancymenu.util.rendering.DrawableColor;
import de.keksuccino.fancymenu.util.rendering.entity.FancyEntityRendererUtils;
import de.keksuccino.fancymenu.util.rendering.entity.WrappedFancyPlayerWidget;
import java.awt.Color;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Objects;
import net.minecraft.class_12079;
import net.minecraft.class_1453;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4050;
import net.minecraft.class_7920;
import net.minecraft.class_7923;
import net.minecraft.class_8685;
import net.minecraft.class_9334;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlayerEntityElement
extends AbstractElement {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final DrawableColor MISSING_FER_COLOR = DrawableColor.of(Color.RED);
    public volatile boolean copyClientPlayer = false;
    @NotNull
    public volatile String playerName = "Steve";
    public boolean showPlayerName = true;
    @NotNull
    public PlayerPose pose = PlayerPose.STANDING;
    public boolean bodyMovement = false;
    public boolean hasParrotOnShoulder = false;
    public boolean parrotOnLeftShoulder = false;
    public boolean isBaby = false;
    public boolean headFollowsMouse = true;
    public boolean bodyFollowsMouse = true;
    public volatile boolean slim = true;
    public volatile boolean autoSkin = false;
    public volatile boolean autoCape = false;
    @Nullable
    public SkinResourceSupplier skinTextureSupplier;
    @Nullable
    public CapeResourceSupplier capeTextureSupplier;
    public String bodyXRot;
    public String bodyYRot;
    public String bodyZRot;
    public String headXRot;
    public String headYRot;
    public String headZRot;
    public String leftArmXRot;
    public String leftArmYRot;
    public String leftArmZRot;
    public String rightArmXRot;
    public String rightArmYRot;
    public String rightArmZRot;
    public String leftLegXRot;
    public String leftLegYRot;
    public String leftLegZRot;
    public String rightLegXRot;
    public String rightLegYRot;
    public String rightLegZRot;
    public boolean bodyXRotAdvancedMode;
    public boolean bodyYRotAdvancedMode;
    public boolean bodyZRotAdvancedMode;
    public boolean headXRotAdvancedMode;
    public boolean headYRotAdvancedMode;
    public boolean headZRotAdvancedMode;
    public boolean leftArmXRotAdvancedMode;
    public boolean leftArmYRotAdvancedMode;
    public boolean leftArmZRotAdvancedMode;
    public boolean rightArmXRotAdvancedMode;
    public boolean rightArmYRotAdvancedMode;
    public boolean rightArmZRotAdvancedMode;
    public boolean leftLegXRotAdvancedMode;
    public boolean leftLegYRotAdvancedMode;
    public boolean leftLegZRotAdvancedMode;
    public boolean rightLegXRotAdvancedMode;
    public boolean rightLegYRotAdvancedMode;
    public boolean rightLegZRotAdvancedMode;
    @NotNull
    public Wearable leftHandWearable = Wearable.empty();
    @NotNull
    public Wearable rightHandWearable = Wearable.empty();
    @NotNull
    public Wearable headWearable = Wearable.empty();
    @NotNull
    public Wearable chestWearable = Wearable.empty();
    @NotNull
    public Wearable legsWearable = Wearable.empty();
    @NotNull
    public Wearable feetWearable = Wearable.empty();
    @Nullable
    protected WrappedFancyPlayerWidget widget = null;

    public PlayerEntityElement(@NotNull ElementBuilder<?, ?> builder) {
        super(builder);
    }

    @Override
    public void afterConstruction() {
        super.afterConstruction();
        if (FancyEntityRendererUtils.isFerLoaded()) {
            this.widget = WrappedFancyPlayerWidget.build(this.getAbsoluteX(), this.getAbsoluteY(), this.getAbsoluteWidth(), this.getAbsoluteHeight());
        }
    }

    @Override
    public void method_25394(@NotNull class_332 graphics, int mouseX, int mouseY, float partial) {
        if (this.shouldRender()) {
            if (this.widget == null) {
                graphics.method_25294(this.getAbsoluteX(), this.getAbsoluteY(), this.getAbsoluteX() + this.getAbsoluteWidth(), this.getAbsoluteY() + this.getAbsoluteHeight(), MISSING_FER_COLOR.getColorInt());
                int xCenter = this.getAbsoluteX() + this.getAbsoluteWidth() / 2;
                int yCenter = this.getAbsoluteY() + this.getAbsoluteHeight() / 2;
                graphics.method_25300(class_310.method_1551().field_1772, "\u00a7lFER (FANCY ENTITY RENDERER) IS NOT INSTALLED!", xCenter, yCenter, -1);
                class_327 class_3272 = class_310.method_1551().field_1772;
                Objects.requireNonNull(class_310.method_1551().field_1772);
                graphics.method_25300(class_3272, "\u00a7lPLEASE DOWNLOAD FROM CURSEFORGE OR MODRINTH!", xCenter, yCenter + 9 + 2, -1);
            } else {
                this.widget.method_46421(this.getAbsoluteX());
                this.widget.method_46419(this.getAbsoluteY());
                this.widget.method_25358(this.getAbsoluteWidth());
                this.widget.method_53533(this.getAbsoluteHeight());
                this.updateSkinAndCape();
                this.updateEntityPose();
                this.updateParrots();
                this.updateWearables();
                this.updateEntityProperties();
                this.widget.method_25394(graphics, mouseX, mouseY, partial);
            }
        }
    }

    protected void updateEntityProperties() {
        if (this.widget != null) {
            this.widget.setShowName(this.showPlayerName);
            this.widget.setName(this.playerName);
            this.widget.setBaby(this.isBaby);
            this.widget.setHeadFollowsMouse(this.headFollowsMouse);
            this.widget.setBodyFollowsMouse(this.bodyFollowsMouse);
            this.widget.setSlim(this.slim);
        }
    }

    protected void updateWearables() {
        if (this.widget == null) {
            return;
        }
        this.widget.setLeftHandItem(this.leftHandWearable.getWearable());
        this.widget.setRightHandItem(this.rightHandWearable.getWearable());
        this.widget.setHeadWearable(this.headWearable.getWearable());
        this.widget.setChestWearable(this.chestWearable.getWearable());
        this.widget.setLegsWearable(this.legsWearable.getWearable());
        this.widget.setFeetWearable(this.feetWearable.getWearable());
    }

    protected void updateParrots() {
        if (this.widget != null) {
            if (!this.hasParrotOnShoulder) {
                this.widget.setParrots(null, null);
            } else if (this.parrotOnLeftShoulder) {
                this.widget.setParrots(class_1453.class_7989.field_41550, null);
            } else {
                this.widget.setParrots(null, class_1453.class_7989.field_41550);
            }
        }
    }

    protected void updateEntityPose() {
        if (this.widget != null) {
            this.widget.setPose(this.pose.pose);
            this.widget.setBodyMovement(this.bodyMovement);
            float bodyXRot = PlayerEntityElement.stringToFloat(this.bodyXRot);
            float bodyYRot = PlayerEntityElement.stringToFloat(this.bodyYRot);
            float bodyZRot = PlayerEntityElement.stringToFloat(this.bodyZRot);
            float headXRot = PlayerEntityElement.stringToFloat(this.headXRot);
            float headYRot = PlayerEntityElement.stringToFloat(this.headYRot);
            float headZRot = PlayerEntityElement.stringToFloat(this.headZRot);
            float leftArmXRot = PlayerEntityElement.stringToFloat(this.leftArmXRot);
            float leftArmYRot = PlayerEntityElement.stringToFloat(this.leftArmYRot);
            float leftArmZRot = PlayerEntityElement.stringToFloat(this.leftArmZRot);
            float rightArmXRot = PlayerEntityElement.stringToFloat(this.rightArmXRot);
            float rightArmYRot = PlayerEntityElement.stringToFloat(this.rightArmYRot);
            float rightArmZRot = PlayerEntityElement.stringToFloat(this.rightArmZRot);
            float leftLegXRot = PlayerEntityElement.stringToFloat(this.leftLegXRot);
            float leftLegYRot = PlayerEntityElement.stringToFloat(this.leftLegYRot);
            float leftLegZRot = PlayerEntityElement.stringToFloat(this.leftLegZRot);
            float rightLegXRot = PlayerEntityElement.stringToFloat(this.rightLegXRot);
            float rightLegYRot = PlayerEntityElement.stringToFloat(this.rightLegYRot);
            float rightLegZRot = PlayerEntityElement.stringToFloat(this.rightLegZRot);
            this.widget.setBodyRotation(bodyXRot, bodyYRot, bodyZRot);
            this.widget.setHeadRotation(headXRot, headYRot, headZRot);
            this.widget.setLeftArmRotation(leftArmXRot, leftArmYRot, leftArmZRot);
            this.widget.setRightArmRotation(rightArmXRot, rightArmYRot, rightArmZRot);
            this.widget.setLeftLegRotation(leftLegXRot, leftLegYRot, leftLegZRot);
            this.widget.setRightLegRotation(rightLegXRot, rightLegYRot, rightLegZRot);
        }
    }

    protected void updateSkinAndCape() {
        if (this.widget == null) {
            return;
        }
        if (this.copyClientPlayer || this.autoSkin) {
            boolean bl = this.slim = this.skinTextureSupplier == null || this.skinTextureSupplier.isSlimPlayerNameSkin();
        }
        if (this.capeTextureSupplier != null && this.capeTextureSupplier.hasNoCape()) {
            this.capeTextureSupplier = null;
        }
        class_2960 skinLoc = this.skinTextureSupplier != null ? this.skinTextureSupplier.getSkinLocation() : SkinResourceSupplier.DEFAULT_SKIN_LOCATION;
        class_2960 capeLoc = null;
        if (this.capeTextureSupplier != null && !this.capeTextureSupplier.hasNoCape() && (capeLoc = this.capeTextureSupplier.getCapeLocation()) == CapeResourceSupplier.DEFAULT_CAPE_LOCATION) {
            capeLoc = null;
        }
        ClientTexture skinTex = new ClientTexture(skinLoc);
        ClientTexture capeTex = capeLoc != null ? new ClientTexture(capeLoc) : null;
        this.widget.setSkin(new class_8685((class_12079.class_12081)skinTex, null, (class_12079.class_12081)capeTex, this.slim ? class_7920.field_41122 : class_7920.field_41123, false));
    }

    public void setCopyClientPlayer(boolean copyClientPlayer) {
        if (copyClientPlayer) {
            this.copyClientPlayer = true;
            this.autoCape = false;
            this.autoSkin = false;
            this.slim = false;
            this.setPlayerName(class_310.method_1551().method_1548().method_1676());
            this.setSkinByPlayerName();
            this.setCapeByPlayerName();
        } else {
            this.copyClientPlayer = false;
            this.skinTextureSupplier = null;
            this.capeTextureSupplier = null;
        }
    }

    public void setPlayerName(@Nullable String playerName) {
        if (playerName == null) {
            playerName = "Steve";
        }
        this.playerName = playerName;
    }

    public void setShowPlayerName(boolean showName) {
        this.showPlayerName = showName;
    }

    public void setHasParrotOnShoulder(boolean hasParrot, boolean onLeftShoulder) {
        this.hasParrotOnShoulder = hasParrot;
        this.parrotOnLeftShoulder = onLeftShoulder;
    }

    public void setIsBaby(boolean isBaby) {
        this.isBaby = isBaby;
    }

    public void setCapeByPlayerName() {
        this.capeTextureSupplier = new CapeResourceSupplier(this.playerName, true);
    }

    public void setSkinByPlayerName() {
        this.skinTextureSupplier = new SkinResourceSupplier(this.playerName, true);
    }

    public void setSkinBySource(@NotNull String resourceSource) {
        this.skinTextureSupplier = new SkinResourceSupplier(resourceSource, false);
    }

    public void setCapeBySource(@NotNull String resourceSource) {
        this.capeTextureSupplier = new CapeResourceSupplier(resourceSource, false);
    }

    protected static float stringToFloat(@Nullable String s) {
        if (s == null) {
            return 0.0f;
        }
        s = PlaceholderParser.replacePlaceholders(s);
        s = s.replace(" ", "");
        try {
            return Float.parseFloat(s);
        }
        catch (Exception exception) {
            return 0.0f;
        }
    }

    public static enum PlayerPose implements LocalizedCycleEnum<PlayerPose>
    {
        STANDING("standing", class_4050.field_18076),
        CROUCHING("crouching", class_4050.field_18081),
        SLEEPING("sleeping", class_4050.field_18078),
        SWIMMING("swimming", class_4050.field_18079),
        DYING("dying", class_4050.field_18082),
        SPIN_ATTACK("spin_attack", class_4050.field_18080);

        public final String name;
        public final class_4050 pose;

        private PlayerPose(String name, class_4050 pose) {
            this.name = name;
            this.pose = pose;
        }

        @Override
        @NotNull
        public String getLocalizationKeyBase() {
            return "fancymenu.elements.player_entity.pose";
        }

        @Override
        @NotNull
        public class_2583 getValueComponentStyle() {
            return (class_2583)WARNING_TEXT_STYLE.get();
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        @NotNull
        public PlayerPose[] getValues() {
            return PlayerPose.values();
        }

        @Override
        @Nullable
        public PlayerPose getByNameInternal(@NotNull String name) {
            return PlayerPose.getByName(name);
        }

        @Nullable
        public static PlayerPose getByName(@Nullable String name) {
            if (name == null) {
                return null;
            }
            for (PlayerPose p : PlayerPose.values()) {
                if (!p.name.equals(name)) continue;
                return p;
            }
            return null;
        }
    }

    public static class Wearable {
        public static final String WEARABLE_EMPTY_KEY = "fancymenu_wearable_none_dummy";
        private static final String SERIALIZATION_SEPARATOR = ":::";
        @NotNull
        public String itemKey;
        public boolean enchanted;
        @NotNull
        public class_1799 cachedStack = new class_1799((class_1935)class_1802.field_8162);
        @Nullable
        protected String lastFinalKey = null;
        protected boolean lastEnchanted = false;

        @NotNull
        public static Wearable empty() {
            return new Wearable(WEARABLE_EMPTY_KEY, false);
        }

        private Wearable(@NotNull String itemKey, boolean enchanted) {
            this.itemKey = itemKey;
            this.enchanted = enchanted;
        }

        public void update() {
            try {
                String keyFinal = PlaceholderParser.replacePlaceholders(this.itemKey);
                if (!keyFinal.equals(this.lastFinalKey) || this.lastEnchanted != this.enchanted) {
                    this.lastFinalKey = keyFinal;
                    this.lastEnchanted = this.enchanted;
                    class_1792 item = (class_1792)class_7923.field_41178.method_63535(class_2960.method_60654((String)keyFinal));
                    this.cachedStack = new class_1799((class_1935)item);
                    this.cachedStack.method_57379(class_9334.field_49641, (Object)this.enchanted);
                }
            }
            catch (Exception ex) {
                LOGGER.error("[FANCYMENU] Failed to update wearable of PlayerEntityElement!", (Throwable)ex);
            }
        }

        public boolean isEmpty() {
            return this.itemKey.equals(WEARABLE_EMPTY_KEY);
        }

        public void setEmpty() {
            this.itemKey = WEARABLE_EMPTY_KEY;
        }

        @Nullable
        public class_1799 getWearable() {
            if (this.isEmpty()) {
                return null;
            }
            this.update();
            return this.cachedStack;
        }

        @NotNull
        public String serialize() {
            StringBuilder serialized = new StringBuilder().append(this.itemKey).append(SERIALIZATION_SEPARATOR).append(this.enchanted);
            return serialized.toString();
        }

        @NotNull
        public static Wearable deserialize(@Nullable String serialized) {
            if (serialized == null) {
                return Wearable.empty();
            }
            try {
                if (serialized.contains(SERIALIZATION_SEPARATOR)) {
                    String[] array = serialized.split(SERIALIZATION_SEPARATOR);
                    String key = array[0];
                    boolean enchant = SerializationUtils.deserializeBoolean(false, array[1]);
                    return new Wearable(key, enchant);
                }
            }
            catch (Exception ex) {
                LOGGER.error("[FANCYMENU] Failed to deserialize Wearable of PlayerEntityElement!", (Throwable)ex);
            }
            return Wearable.empty();
        }
    }

    public static final class ClientTexture
    extends Record
    implements class_12079.class_12081 {
        private final class_2960 texturePath;

        public ClientTexture(class_2960 texturePath) {
            this.texturePath = texturePath;
        }

        @NotNull
        public class_2960 comp_3626() {
            return this.comp_3627();
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{ClientTexture.class, "texturePath", "texturePath"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{ClientTexture.class, "texturePath", "texturePath"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{ClientTexture.class, "texturePath", "texturePath"}, this, o);
        }

        public class_2960 comp_3627() {
            return this.texturePath;
        }
    }
}

