/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.quad;

import java.util.Arrays;
import net.caffeinemc.mods.sodium.api.util.NormI8;
import net.caffeinemc.mods.sodium.client.model.quad.properties.ModelQuadFacing;
import net.caffeinemc.mods.sodium.client.render.chunk.vertex.format.ChunkVertexEncoder;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public abstract class TQuad {
    public static final float VERTEX_EPSILON = 1.0E-5f;
    static final int NORMAL_QUANTIZATION_STEPS = 4;
    private static final float INV_QUANTIZE_EPSILON = 256.0f;
    public static final float QUANTIZE_EPSILON = 0.00390625f;
    ModelQuadFacing facing;
    final int packedNormal;
    float[] extents;
    float accurateDotProduct;
    float quantizedDotProduct;
    Vector3fc center;
    Vector3fc quantizedNormal;
    Vector3fc accurateNormal;

    TQuad(ModelQuadFacing facing, int packedNormal) {
        if (facing.isAligned()) {
            packedNormal = ModelQuadFacing.PACKED_ALIGNED_NORMALS[facing.ordinal()];
        }
        this.facing = facing;
        this.packedNormal = packedNormal;
    }

    protected static boolean isInvalid(int sameVertexMap) {
        return Integer.bitCount(sameVertexMap) > 1;
    }

    int initExtentsAndCenter(ChunkVertexEncoder.Vertex[] vertices) {
        float xSum = 0.0f;
        float ySum = 0.0f;
        float zSum = 0.0f;
        float lastX = vertices[3].x;
        float lastY = vertices[3].y;
        float lastZ = vertices[3].z;
        int sameVertexMap = 0;
        float posXExtent = Float.NEGATIVE_INFINITY;
        float posYExtent = Float.NEGATIVE_INFINITY;
        float posZExtent = Float.NEGATIVE_INFINITY;
        float negXExtent = Float.POSITIVE_INFINITY;
        float negYExtent = Float.POSITIVE_INFINITY;
        float negZExtent = Float.POSITIVE_INFINITY;
        for (int i = 0; i < 4; ++i) {
            float x = vertices[i].x;
            float y = vertices[i].y;
            float z = vertices[i].z;
            posXExtent = Math.max(posXExtent, x);
            posYExtent = Math.max(posYExtent, y);
            posZExtent = Math.max(posZExtent, z);
            negXExtent = Math.min(negXExtent, x);
            negYExtent = Math.min(negYExtent, y);
            negZExtent = Math.min(negZExtent, z);
            if (Math.abs(x - lastX) >= 1.0E-5f || Math.abs(y - lastY) >= 1.0E-5f || Math.abs(z - lastZ) >= 1.0E-5f) {
                xSum += x;
                ySum += y;
                zSum += z;
            } else {
                sameVertexMap |= 1 << i;
            }
            if (i == 3) continue;
            lastX = x;
            lastY = y;
            lastZ = z;
        }
        if (this.facing != ModelQuadFacing.POS_X && this.facing != ModelQuadFacing.NEG_X && (negXExtent += 0.00390625f) > (posXExtent -= 0.00390625f)) {
            negXExtent = posXExtent;
        }
        if (this.facing != ModelQuadFacing.POS_Y && this.facing != ModelQuadFacing.NEG_Y && (negYExtent += 0.00390625f) > (posYExtent -= 0.00390625f)) {
            negYExtent = posYExtent;
        }
        if (this.facing != ModelQuadFacing.POS_Z && this.facing != ModelQuadFacing.NEG_Z && (negZExtent += 0.00390625f) > (posZExtent -= 0.00390625f)) {
            negZExtent = posZExtent;
        }
        this.extents = new float[]{posXExtent, posYExtent, posZExtent, negXExtent, negYExtent, negZExtent};
        int uniqueVertexes = 4 - Integer.bitCount(sameVertexMap);
        if (!(this.facing.isAligned() && uniqueVertexes == 4 || uniqueVertexes < 3)) {
            float invUniqueVertexes = 1.0f / (float)uniqueVertexes;
            float centerX = xSum * invUniqueVertexes;
            float centerY = ySum * invUniqueVertexes;
            float centerZ = zSum * invUniqueVertexes;
            this.center = new Vector3f(centerX, centerY, centerZ);
        }
        return sameVertexMap;
    }

    void initDotProduct() {
        if (this.facing.isAligned()) {
            this.accurateDotProduct = TQuad.getAlignedDotProduct(this.facing, this.extents);
        } else {
            float normX = NormI8.unpackX(this.packedNormal);
            float normY = NormI8.unpackY(this.packedNormal);
            float normZ = NormI8.unpackZ(this.packedNormal);
            this.accurateDotProduct = this.getCenter().dot(normX, normY, normZ);
        }
        this.quantizedDotProduct = this.accurateDotProduct;
    }

    private static float getAlignedDotProduct(ModelQuadFacing facing, float[] extents) {
        return extents[facing.ordinal()] * (float)facing.getSign();
    }

    public abstract float[] getVertexPositions();

    public ModelQuadFacing getFacing() {
        return this.facing;
    }

    public ModelQuadFacing useQuantizedFacing() {
        if (!this.facing.isAligned()) {
            this.getQuantizedNormal();
            this.facing = ModelQuadFacing.fromNormal(this.quantizedNormal);
            this.quantizedDotProduct = this.facing.isAligned() ? TQuad.getAlignedDotProduct(this.facing, this.extents) : this.getCenter().dot(this.quantizedNormal);
        }
        return this.facing;
    }

    public float[] getExtents() {
        return this.extents;
    }

    public Vector3fc getCenter() {
        if (this.center == null) {
            this.center = new Vector3f((this.extents[0] + this.extents[3]) / 2.0f, (this.extents[1] + this.extents[4]) / 2.0f, (this.extents[2] + this.extents[5]) / 2.0f);
        }
        return this.center;
    }

    public float getAccurateDotProduct() {
        return this.accurateDotProduct;
    }

    public float getQuantizedDotProduct() {
        return this.quantizedDotProduct;
    }

    public int getPackedNormal() {
        return this.packedNormal;
    }

    public Vector3fc getQuantizedNormal() {
        if (this.quantizedNormal == null) {
            if (this.facing.isAligned()) {
                this.quantizedNormal = this.facing.getAlignedNormal();
            } else {
                this.computeQuantizedNormal();
            }
        }
        return this.quantizedNormal;
    }

    public Vector3fc getAccurateNormal() {
        if (this.facing.isAligned()) {
            return this.facing.getAlignedNormal();
        }
        if (this.accurateNormal == null) {
            this.accurateNormal = new Vector3f(NormI8.unpackX(this.packedNormal), NormI8.unpackY(this.packedNormal), NormI8.unpackZ(this.packedNormal));
        }
        return this.accurateNormal;
    }

    private void computeQuantizedNormal() {
        float normX = NormI8.unpackX(this.packedNormal);
        float normY = NormI8.unpackY(this.packedNormal);
        float normZ = NormI8.unpackZ(this.packedNormal);
        float infNormLength = Math.max(Math.abs(normX), Math.max(Math.abs(normY), Math.abs(normZ)));
        if (infNormLength != 0.0f && infNormLength != 1.0f) {
            normX /= infNormLength;
            normY /= infNormLength;
            normZ /= infNormLength;
        }
        Vector3f normal = new Vector3f((float)((int)(normX * 4.0f)), (float)((int)(normY * 4.0f)), (float)((int)(normZ * 4.0f)));
        normal.normalize();
        this.quantizedNormal = normal;
    }

    public int getQuadHash() {
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.extents);
        result = this.facing.isAligned() ? 31 * result + this.facing.hashCode() : 31 * result + this.packedNormal;
        result = 31 * result + Float.hashCode(this.quantizedDotProduct);
        return result;
    }

    public boolean extentsEqual(float[] other) {
        return TQuad.extentsEqual(this.extents, other);
    }

    public static boolean extentsEqual(float[] a, float[] b) {
        for (int i = 0; i < 6; ++i) {
            if (a[i] == b[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean extentsIntersect(float[] extentsA, float[] extentsB) {
        for (int axis = 0; axis < 3; ++axis) {
            int opposite = axis + 3;
            if (!(extentsA[axis] <= extentsB[opposite]) && !(extentsB[axis] <= extentsA[opposite])) continue;
            return false;
        }
        return true;
    }

    public static boolean extentsIntersect(TQuad a, TQuad b) {
        return TQuad.extentsIntersect(a.extents, b.extents);
    }

    static {
        float targetEpsilon = 0.0021f;
        if (0.00390625f <= targetEpsilon && Integer.bitCount(256) == 1) {
            throw new RuntimeException("epsilon is invalid: 0.00390625");
        }
    }
}

