/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.render.chunk.lists;

import java.util.Arrays;
import net.caffeinemc.mods.sodium.client.render.chunk.LocalSectionIndex;
import net.caffeinemc.mods.sodium.client.render.chunk.RenderSection;
import net.caffeinemc.mods.sodium.client.render.chunk.lists.SortItemsProvider;
import net.caffeinemc.mods.sodium.client.render.chunk.region.RenderRegion;
import net.caffeinemc.mods.sodium.client.util.iterator.ByteArrayIterator;
import net.caffeinemc.mods.sodium.client.util.iterator.ByteIterator;
import net.caffeinemc.mods.sodium.client.util.iterator.ReversibleByteArrayIterator;
import net.minecraft.class_3532;
import net.minecraft.class_4076;
import org.jspecify.annotations.Nullable;

public class ChunkRenderList {
    private final RenderRegion region;
    private final byte[] sectionsWithGeometry = new byte[256];
    private final long[] sectionsWithGeometryMap = new long[4];
    private final long[] prevSectionsWithGeometryMap = new long[4];
    private int sectionsWithGeometryCount = 0;
    private int prevSectionsWithGeometryCount = 0;
    private int lastRelativeCameraSectionX;
    private int lastRelativeCameraSectionY;
    private int lastRelativeCameraSectionZ;
    private boolean addedSectionsAreSorted = false;
    private final byte[] sectionsWithSprites = new byte[256];
    private int sectionsWithSpritesCount = 0;
    private final byte[] sectionsWithEntities = new byte[256];
    private int sectionsWithEntitiesCount = 0;
    private int size;
    private int lastVisibleFrame;
    private static final int SORTING_HISTOGRAM_SIZE = 18;

    public ChunkRenderList(RenderRegion region) {
        this.region = region;
    }

    public void reset(int frame, boolean addedSectionsAreSorted) {
        this.prevSectionsWithGeometryCount = this.sectionsWithGeometryCount;
        Arrays.fill(this.sectionsWithGeometryMap, 0L);
        this.sectionsWithGeometryCount = 0;
        this.sectionsWithSpritesCount = 0;
        this.sectionsWithEntitiesCount = 0;
        this.size = 0;
        this.lastVisibleFrame = frame;
        this.addedSectionsAreSorted = addedSectionsAreSorted;
    }

    public void prepareForRender(class_4076 cameraPos, SortItemsProvider sortItemsProvider) {
        int relativeCameraSectionX = class_3532.method_15340((int)(cameraPos.method_10263() - this.region.getChunkX()), (int)-1, (int)8);
        int relativeCameraSectionY = class_3532.method_15340((int)(cameraPos.method_10264() - this.region.getChunkY()), (int)-1, (int)4);
        int relativeCameraSectionZ = class_3532.method_15340((int)(cameraPos.method_10260() - this.region.getChunkZ()), (int)-1, (int)8);
        if (this.prevSectionsWithGeometryCount != this.sectionsWithGeometryCount || relativeCameraSectionX != this.lastRelativeCameraSectionX || relativeCameraSectionY != this.lastRelativeCameraSectionY || relativeCameraSectionZ != this.lastRelativeCameraSectionZ || !Arrays.equals(this.sectionsWithGeometryMap, this.prevSectionsWithGeometryMap)) {
            this.region.clearAllCachedBatches();
            this.prevSectionsWithGeometryCount = this.sectionsWithGeometryCount;
            System.arraycopy(this.sectionsWithGeometryMap, 0, this.prevSectionsWithGeometryMap, 0, this.sectionsWithGeometryMap.length);
            this.lastRelativeCameraSectionX = relativeCameraSectionX;
            this.lastRelativeCameraSectionY = relativeCameraSectionY;
            this.lastRelativeCameraSectionZ = relativeCameraSectionZ;
            if (!this.addedSectionsAreSorted) {
                this.sortSections(relativeCameraSectionX, relativeCameraSectionY, relativeCameraSectionZ, sortItemsProvider);
            }
        }
    }

    private void sortSections(int relativeCameraSectionX, int relativeCameraSectionY, int relativeCameraSectionZ, SortItemsProvider sortItemsProvider) {
        int i;
        relativeCameraSectionX = class_3532.method_15340((int)relativeCameraSectionX, (int)0, (int)7);
        relativeCameraSectionY = class_3532.method_15340((int)relativeCameraSectionY, (int)0, (int)3);
        relativeCameraSectionZ = class_3532.method_15340((int)relativeCameraSectionZ, (int)0, (int)7);
        int[] histogram = new int[18];
        int[] sortItems = sortItemsProvider.ensureSortItemsOfLength(this.sectionsWithGeometryCount);
        this.sectionsWithGeometryCount = 0;
        for (int mapIndex = 0; mapIndex < this.sectionsWithGeometryMap.length; ++mapIndex) {
            int mapOffset = mapIndex << 6;
            for (long map = this.sectionsWithGeometryMap[mapIndex]; map != 0L; map &= map - 1L) {
                int distance;
                int index = Long.numberOfTrailingZeros(map) + mapOffset;
                int x = Math.abs(LocalSectionIndex.unpackX(index) - relativeCameraSectionX);
                int y = Math.abs(LocalSectionIndex.unpackY(index) - relativeCameraSectionY);
                int z = Math.abs(LocalSectionIndex.unpackZ(index) - relativeCameraSectionZ);
                int n = distance = x + y + z;
                histogram[n] = histogram[n] + 1;
                sortItems[this.sectionsWithGeometryCount++] = distance << 8 | index;
            }
        }
        for (i = 1; i < 18; ++i) {
            int n = i;
            histogram[n] = histogram[n] + histogram[i - 1];
        }
        for (i = 0; i < this.sectionsWithGeometryCount; ++i) {
            int distance;
            int item = sortItems[i];
            int n = distance = item >>> 8;
            int n2 = histogram[n] - 1;
            histogram[n] = n2;
            this.sectionsWithGeometry[n2] = (byte)item;
        }
    }

    public void add(RenderSection render) {
        if (this.size >= 256) {
            throw new ArrayIndexOutOfBoundsException("Render list is full");
        }
        ++this.size;
        int index = render.getSectionIndex();
        int flags = render.getFlags();
        if ((flags >>> 0 & 1) == 1) {
            int n = index >> 6;
            this.sectionsWithGeometryMap[n] = this.sectionsWithGeometryMap[n] | 1L << (index & 0x3F);
            if (this.addedSectionsAreSorted) {
                this.sectionsWithGeometry[this.sectionsWithGeometryCount] = (byte)index;
            }
            ++this.sectionsWithGeometryCount;
        }
        this.sectionsWithSprites[this.sectionsWithSpritesCount] = (byte)index;
        this.sectionsWithSpritesCount += flags >>> 2 & 1;
        this.sectionsWithEntities[this.sectionsWithEntitiesCount] = (byte)index;
        this.sectionsWithEntitiesCount += flags >>> 1 & 1;
    }

    public @Nullable ByteIterator sectionsWithGeometryIterator(boolean reverse) {
        if (this.sectionsWithGeometryCount == 0) {
            return null;
        }
        return new ReversibleByteArrayIterator(this.sectionsWithGeometry, this.sectionsWithGeometryCount, reverse);
    }

    public @Nullable ByteIterator sectionsWithSpritesIterator() {
        if (this.sectionsWithSpritesCount == 0) {
            return null;
        }
        return new ByteArrayIterator(this.sectionsWithSprites, this.sectionsWithSpritesCount);
    }

    public @Nullable ByteIterator sectionsWithEntitiesIterator() {
        if (this.sectionsWithEntitiesCount == 0) {
            return null;
        }
        return new ByteArrayIterator(this.sectionsWithEntities, this.sectionsWithEntitiesCount);
    }

    public int getSectionsWithGeometryCount() {
        return this.sectionsWithGeometryCount;
    }

    public int getSectionsWithSpritesCount() {
        return this.sectionsWithSpritesCount;
    }

    public int getSectionsWithEntitiesCount() {
        return this.sectionsWithEntitiesCount;
    }

    public int getLastVisibleFrame() {
        return this.lastVisibleFrame;
    }

    public RenderRegion getRegion() {
        return this.region;
    }

    public int size() {
        return this.size;
    }
}

