/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.config.structure;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Collection;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import net.caffeinemc.mods.sodium.api.config.ConfigState;
import net.caffeinemc.mods.sodium.api.config.StorageEventHandler;
import net.caffeinemc.mods.sodium.api.config.option.OptionBinding;
import net.caffeinemc.mods.sodium.api.config.option.OptionImpact;
import net.caffeinemc.mods.sodium.client.config.structure.Option;
import net.caffeinemc.mods.sodium.client.config.value.DependentValue;
import net.caffeinemc.mods.sodium.client.config.value.DynamicValue;
import net.minecraft.class_2561;
import net.minecraft.class_2960;

public abstract class StatefulOption<V>
extends Option {
    final StorageEventHandler storage;
    final Function<V, class_2561> tooltipProvider;
    final OptionImpact impact;
    final Set<class_2960> flags;
    final DependentValue<V> defaultValue;
    final Boolean controlHiddenWhenDisabled;
    final OptionBinding<V> binding;
    final Consumer<ConfigState> applyHook;
    final class_2960 applyHookId;
    private final Collection<DynamicValue<?>> dependents = new ObjectOpenHashSet(0);
    private final Collection<DynamicValue<?>> applyDependents = new ObjectOpenHashSet(0);
    private V value;
    private V modifiedValue;

    StatefulOption(class_2960 id, Collection<class_2960> dependencies, class_2561 name, DependentValue<Boolean> enabled, StorageEventHandler storage, Function<V, class_2561> tooltipProvider, OptionImpact impact, Set<class_2960> flags, DependentValue<V> defaultValue, Boolean controlHiddenWhenDisabled, OptionBinding<V> binding, Consumer<ConfigState> applyHook) {
        super(id, dependencies, name, enabled);
        this.storage = storage;
        this.tooltipProvider = tooltipProvider;
        this.impact = impact;
        this.flags = flags;
        this.defaultValue = defaultValue;
        this.controlHiddenWhenDisabled = controlHiddenWhenDisabled;
        this.binding = binding;
        this.applyHook = applyHook;
        this.applyHookId = applyHook != null ? class_2960.method_60655((String)"__meta__", (String)("apply_hook_" + id.method_12836() + "_" + id.method_12832())) : null;
    }

    @Override
    void visitDependentValues(Consumer<DependentValue<?>> visitor) {
        super.visitDependentValues(visitor);
        visitor.accept(this.defaultValue);
    }

    void registerDependent(DynamicValue<?> dependent) {
        this.dependents.add(dependent);
    }

    void registerApplyDependent(DynamicValue<?> dependent) {
        this.applyDependents.add(dependent);
    }

    public void modifyValue(V value) {
        if (this.modifiedValue != value) {
            this.modifiedValue = value;
            this.state.invalidateDependents(this.dependents);
        }
    }

    @Override
    void loadValueInitial() {
        this.value = this.binding.load();
        this.modifiedValue = this.value;
    }

    @Override
    void resetFromBinding() {
        V previousValue = this.modifiedValue;
        this.value = this.binding.load();
        V newValue = this.validateValue(this.value);
        if (newValue != this.value) {
            this.value = newValue;
            this.binding.save(this.value);
            this.state.notifyStorageWrite(this.storage);
        }
        this.modifiedValue = this.value;
        if (this.value != previousValue) {
            this.state.invalidateDependents(this.dependents);
            this.state.invalidateDependents(this.applyDependents);
        }
    }

    public V getValidatedValue() {
        V newValue = this.validateValue(this.modifiedValue);
        if (newValue != this.modifiedValue) {
            this.modifiedValue = newValue;
            this.state.invalidateDependents(this.dependents);
        }
        return this.modifiedValue;
    }

    public V getAppliedValue() {
        return this.value;
    }

    abstract V validateValue(V var1);

    @Override
    public boolean hasChanged() {
        return this.modifiedValue != this.value;
    }

    @Override
    boolean applyChanges() {
        if (this.hasChanged()) {
            this.value = this.modifiedValue;
            this.binding.save(this.value);
            this.state.notifyStorageWrite(this.storage);
            this.state.invalidateDependents(this.applyDependents);
            return true;
        }
        return false;
    }

    @Override
    public OptionImpact getImpact() {
        return this.impact;
    }

    @Override
    public class_2561 getTooltip() {
        return this.tooltipProvider.apply(this.getValidatedValue());
    }

    @Override
    public Set<class_2960> getFlags() {
        return this.flags;
    }

    public StorageEventHandler getStorage() {
        return this.storage;
    }

    public Function<V, class_2561> getTooltipProvider() {
        return this.tooltipProvider;
    }

    public DependentValue<V> getDefaultValue() {
        return this.defaultValue;
    }

    public Boolean getControlHiddenWhenDisabled() {
        return this.controlHiddenWhenDisabled;
    }

    public boolean showControl() {
        if (this.isEnabled()) {
            return true;
        }
        if (this.controlHiddenWhenDisabled == null) {
            return false;
        }
        return this.controlHiddenWhenDisabled == false;
    }

    public OptionBinding<V> getBinding() {
        return this.binding;
    }

    public Consumer<ConfigState> getApplyHook() {
        return this.applyHook;
    }

    public class_2960 getApplyHookId() {
        return this.applyHookId;
    }
}

